/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ScopeConfigurator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.internal.LoggerConfig;

public final class SdkLoggerProviderUtil {
    private SdkLoggerProviderUtil() {
    }

    public static void setLoggerConfigurator(SdkLoggerProviderBuilder sdkLoggerProviderBuilder, ScopeConfigurator<LoggerConfig> loggerConfigurator) {
        try {
            Method method = SdkLoggerProviderBuilder.class.getDeclaredMethod("setLoggerConfigurator", ScopeConfigurator.class);
            method.setAccessible(true);
            method.invoke((Object)sdkLoggerProviderBuilder, loggerConfigurator);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setLoggerConfigurator on SdkLoggerProviderBuilder", e);
        }
    }

    public static void addLoggerConfiguratorCondition(SdkLoggerProviderBuilder sdkLoggerProviderBuilder, Predicate<InstrumentationScopeInfo> scopeMatcher, LoggerConfig loggerConfig) {
        try {
            Method method = SdkLoggerProviderBuilder.class.getDeclaredMethod("addLoggerConfiguratorCondition", Predicate.class, LoggerConfig.class);
            method.setAccessible(true);
            method.invoke((Object)sdkLoggerProviderBuilder, scopeMatcher, loggerConfig);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling addLoggerConfiguratorCondition on SdkLoggerProviderBuilder", e);
        }
    }
}

