/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.core.metadata.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.NullsOrderType;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPI;
import org.apache.shardingsphere.infra.spi.annotation.SingletonSPI;

@SingletonSPI
public interface DialectDatabaseMetaData
extends DatabaseTypedSPI {
    public QuoteCharacter getQuoteCharacter();

    default public Map<String, Integer> getExtraDataTypes() {
        return Collections.emptyMap();
    }

    public NullsOrderType getDefaultNullsOrderType();

    default public boolean isReservedWord(String identifier) {
        return false;
    }

    default public boolean isSchemaAvailable() {
        return false;
    }

    default public String getSchema(Connection connection) {
        try {
            return connection.getSchema();
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    default public Optional<String> getDefaultSchema() {
        return Optional.empty();
    }

    default public String formatTableNamePattern(String tableNamePattern) {
        return tableNamePattern;
    }

    default public boolean isInstanceConnectionAvailable() {
        return false;
    }

    default public boolean isSupportThreeTierStorageStructure() {
        return false;
    }

    default public boolean isSupportGlobalCSN() {
        return false;
    }
}

