/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceGeneratedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceProvidedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.instance.metadata.jdbc.JDBCInstanceMetaData;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.statistics.builder.ShardingSphereStatisticsBuilder;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.metadata.factory.ExternalMetaDataFactory;
import org.apache.shardingsphere.metadata.factory.InternalMetaDataFactory;
import org.apache.shardingsphere.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.decorator.RuleConfigurationPersistDecorateEngine;
import org.apache.shardingsphere.mode.metadata.manager.SwitchingResource;
import org.apache.shardingsphere.mode.spi.RuleConfigurationPersistDecorator;

public final class MetaDataContextsFactory {
    public static MetaDataContexts create(MetaDataPersistService persistService, ContextManagerBuilderParameter param, ComputeNodeInstanceContext computeNodeInstanceContext) throws SQLException {
        return persistService.getDatabaseMetaDataFacade().getDatabase().loadAllDatabaseNames().isEmpty() ? MetaDataContextsFactory.createByLocal(persistService, param, computeNodeInstanceContext) : MetaDataContextsFactory.createByRepository(persistService, param, computeNodeInstanceContext);
    }

    public static MetaDataContexts create(MetaDataPersistService persistService, ShardingSphereMetaData metaData) {
        return new MetaDataContexts(metaData, MetaDataContextsFactory.initStatistics(persistService, metaData));
    }

    private static MetaDataContexts createByLocal(MetaDataPersistService persistService, ContextManagerBuilderParameter param, ComputeNodeInstanceContext computeNodeInstanceContext) throws SQLException {
        Collection<RuleConfiguration> globalRuleConfigs;
        Map<String, DatabaseConfiguration> effectiveDatabaseConfigs = param.getDatabaseConfigs();
        if (computeNodeInstanceContext.getModeConfiguration().isCluster()) {
            globalRuleConfigs = new RuleConfigurationPersistDecorateEngine(computeNodeInstanceContext).tryRestore(param.getGlobalRuleConfigs());
            param.getGlobalRuleConfigs().clear();
            param.getGlobalRuleConfigs().addAll(globalRuleConfigs);
        } else {
            globalRuleConfigs = param.getGlobalRuleConfigs();
        }
        ConfigurationProperties props = new ConfigurationProperties(param.getProps());
        Map databases = ExternalMetaDataFactory.create(effectiveDatabaseConfigs, (ConfigurationProperties)props, (ComputeNodeInstanceContext)computeNodeInstanceContext);
        MetaDataContexts result = MetaDataContextsFactory.newMetaDataContexts(persistService, param, globalRuleConfigs, databases, props);
        MetaDataContextsFactory.persistDatabaseConfigurations(result, param, persistService, computeNodeInstanceContext);
        MetaDataContextsFactory.persistMetaData(result, persistService);
        return result;
    }

    private static MetaDataContexts createByRepository(MetaDataPersistService persistService, ContextManagerBuilderParameter param, ComputeNodeInstanceContext computeNodeInstanceContext) {
        Map<String, DatabaseConfiguration> effectiveDatabaseConfigs = MetaDataContextsFactory.createEffectiveDatabaseConfigurations(MetaDataContextsFactory.getDatabaseNames(computeNodeInstanceContext, param.getDatabaseConfigs(), persistService), param.getDatabaseConfigs(), persistService);
        Collection globalRuleConfigs = persistService.getGlobalRuleService().load();
        ConfigurationProperties props = new ConfigurationProperties(persistService.getPropsService().load());
        Map databases = InternalMetaDataFactory.create((MetaDataPersistService)persistService, effectiveDatabaseConfigs, (ConfigurationProperties)props, (ComputeNodeInstanceContext)computeNodeInstanceContext);
        MetaDataContexts result = MetaDataContextsFactory.newMetaDataContexts(persistService, param, globalRuleConfigs, databases, props);
        MetaDataContextsFactory.restoreRules(result, computeNodeInstanceContext);
        return result;
    }

    private static MetaDataContexts newMetaDataContexts(MetaDataPersistService persistService, ContextManagerBuilderParameter param, Collection<RuleConfiguration> globalRuleConfigs, Map<String, ShardingSphereDatabase> databases, ConfigurationProperties props) {
        ResourceMetaData globalResourceMetaData = new ResourceMetaData(param.getGlobalDataSources());
        RuleMetaData globalRuleMetaData = new RuleMetaData(GlobalRulesBuilder.buildRules(globalRuleConfigs, databases, (ConfigurationProperties)props));
        ShardingSphereMetaData shardingSphereMetaData = new ShardingSphereMetaData(databases, globalResourceMetaData, globalRuleMetaData, props);
        ShardingSphereStatistics shardingSphereStatistics = MetaDataContextsFactory.initStatistics(persistService, shardingSphereMetaData);
        return new MetaDataContexts(shardingSphereMetaData, shardingSphereStatistics);
    }

    private static Collection<String> getDatabaseNames(ComputeNodeInstanceContext computeNodeInstanceContext, Map<String, DatabaseConfiguration> databaseConfigs, MetaDataPersistService persistService) {
        return computeNodeInstanceContext.getInstance().getMetaData() instanceof JDBCInstanceMetaData ? databaseConfigs.keySet() : persistService.getDatabaseMetaDataFacade().getDatabase().loadAllDatabaseNames();
    }

    private static Map<String, DatabaseConfiguration> createEffectiveDatabaseConfigurations(Collection<String> databaseNames, Map<String, DatabaseConfiguration> databaseConfigs, MetaDataPersistService persistService) {
        return databaseNames.stream().collect(Collectors.toMap(each -> each, each -> MetaDataContextsFactory.createEffectiveDatabaseConfiguration(each, databaseConfigs, persistService)));
    }

    private static DatabaseConfiguration createEffectiveDatabaseConfiguration(String databaseName, Map<String, DatabaseConfiguration> databaseConfigs, MetaDataPersistService persistService) {
        MetaDataContextsFactory.closeGeneratedDataSources(databaseName, databaseConfigs);
        Map dataSources = persistService.loadDataSourceConfigurations(databaseName);
        Collection databaseRuleConfigs = persistService.getDatabaseRulePersistService().load(databaseName);
        return new DataSourceGeneratedDatabaseConfiguration(dataSources, databaseRuleConfigs);
    }

    private static void closeGeneratedDataSources(String databaseName, Map<String, ? extends DatabaseConfiguration> databaseConfigs) {
        if (databaseConfigs.containsKey(databaseName) && !databaseConfigs.get(databaseName).getStorageUnits().isEmpty()) {
            databaseConfigs.get(databaseName).getDataSources().values().forEach(each -> new DataSourcePoolDestroyer(each).asyncDestroy());
        }
    }

    private static ShardingSphereStatistics initStatistics(MetaDataPersistService persistService, ShardingSphereMetaData metaData) {
        if (metaData.getDatabases().isEmpty()) {
            return new ShardingSphereStatistics();
        }
        DatabaseType protocolType = ((ShardingSphereDatabase)metaData.getDatabases().values().iterator().next()).getProtocolType();
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(protocolType).getDialectDatabaseMetaData();
        DatabaseType databaseType = dialectDatabaseMetaData.getDefaultSchema().isPresent() ? (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"PostgreSQL") : protocolType;
        Optional statisticsBuilder = DatabaseTypedSPILoader.findService(ShardingSphereStatisticsBuilder.class, (DatabaseType)databaseType);
        if (!statisticsBuilder.isPresent()) {
            return new ShardingSphereStatistics();
        }
        ShardingSphereStatistics result = ((ShardingSphereStatisticsBuilder)statisticsBuilder.get()).build(metaData);
        Optional loadedStatistics = persistService.getShardingSphereDataPersistService().load(metaData);
        loadedStatistics.ifPresent(optional -> MetaDataContextsFactory.useLoadedToReplaceInit(result, optional));
        return result;
    }

    private static void useLoadedToReplaceInit(ShardingSphereStatistics initStatistics, ShardingSphereStatistics loadedStatistics) {
        for (Map.Entry entry : initStatistics.getDatabaseData().entrySet()) {
            if (!loadedStatistics.getDatabaseData().containsKey(entry.getKey())) continue;
            MetaDataContextsFactory.useLoadedToReplaceInitByDatabaseData((ShardingSphereDatabaseData)entry.getValue(), (ShardingSphereDatabaseData)loadedStatistics.getDatabaseData().get(entry.getKey()));
        }
    }

    private static void useLoadedToReplaceInitByDatabaseData(ShardingSphereDatabaseData initDatabaseData, ShardingSphereDatabaseData loadedDatabaseData) {
        for (Map.Entry entry : initDatabaseData.getSchemaData().entrySet()) {
            if (!loadedDatabaseData.getSchemaData().containsKey(entry.getKey())) continue;
            MetaDataContextsFactory.useLoadedToReplaceInitBySchemaData((ShardingSphereSchemaData)entry.getValue(), (ShardingSphereSchemaData)loadedDatabaseData.getSchemaData().get(entry.getKey()));
        }
    }

    private static void useLoadedToReplaceInitBySchemaData(ShardingSphereSchemaData initSchemaData, ShardingSphereSchemaData loadedSchemaData) {
        for (Map.Entry entry : initSchemaData.getTableData().entrySet()) {
            if (!loadedSchemaData.getTableData().containsKey(entry.getKey())) continue;
            entry.setValue((ShardingSphereTableData)loadedSchemaData.getTableData().get(entry.getKey()));
        }
    }

    private static void restoreRules(MetaDataContexts metaDataContexts, ComputeNodeInstanceContext computeNodeInstanceContext) {
        if (!computeNodeInstanceContext.getModeConfiguration().isCluster()) {
            return;
        }
        for (RuleConfigurationPersistDecorator each : ShardingSphereServiceLoader.getServiceInstances(RuleConfigurationPersistDecorator.class)) {
            ShardingSphereRule rule = metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(each.getRuleType());
            metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules().removeIf(eachRule -> each.getRuleType() == eachRule.getClass());
            RuleConfiguration restoredRuleConfig = each.restore(rule.getConfiguration());
            ShardingSphereRule rebuiltRule = (ShardingSphereRule)GlobalRulesBuilder.buildRules(Collections.singleton(restoredRuleConfig), (Map)metaDataContexts.getMetaData().getDatabases(), (ConfigurationProperties)metaDataContexts.getMetaData().getProps()).iterator().next();
            metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules().add(rebuiltRule);
        }
    }

    private static void persistDatabaseConfigurations(MetaDataContexts metadataContexts, ContextManagerBuilderParameter param, MetaDataPersistService persistService, ComputeNodeInstanceContext computeNodeInstanceContext) {
        RuleConfigurationPersistDecorateEngine ruleConfigPersistDecorateEngine = new RuleConfigurationPersistDecorateEngine(computeNodeInstanceContext);
        persistService.persistGlobalRuleConfiguration(ruleConfigPersistDecorateEngine.decorate(metadataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations()), param.getProps());
        for (Map.Entry<String, DatabaseConfiguration> entry : param.getDatabaseConfigs().entrySet()) {
            String databaseName = entry.getKey();
            persistService.persistConfigurations(entry.getKey(), entry.getValue(), (Map)metadataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData().getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, each -> ((StorageUnit)each.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)), metadataContexts.getMetaData().getDatabase(databaseName).getRuleMetaData().getRules());
        }
    }

    private static void persistMetaData(MetaDataContexts metaDataContexts, MetaDataPersistService persistService) {
        metaDataContexts.getMetaData().getDatabases().values().forEach(each -> each.getSchemas().forEach((schemaName, schema) -> {
            if (schema.isEmpty()) {
                persistService.getDatabaseMetaDataFacade().getSchema().add(each.getName(), schemaName);
            }
            persistService.getDatabaseMetaDataFacade().getTable().persist(each.getName(), schemaName, schema.getTables());
        }));
        for (Map.Entry databaseDataEntry : metaDataContexts.getStatistics().getDatabaseData().entrySet()) {
            for (Map.Entry schemaDataEntry : ((ShardingSphereDatabaseData)databaseDataEntry.getValue()).getSchemaData().entrySet()) {
                persistService.getShardingSphereDataPersistService().persist((ShardingSphereDatabase)metaDataContexts.getMetaData().getDatabases().get(((String)databaseDataEntry.getKey()).toLowerCase()), (String)schemaDataEntry.getKey(), (ShardingSphereSchemaData)schemaDataEntry.getValue());
            }
        }
    }

    public static MetaDataContexts createBySwitchResource(String databaseName, boolean internalLoadMetaData, SwitchingResource switchingResource, MetaDataContexts originalMetaDataContexts, MetaDataPersistService metaDataPersistService, ComputeNodeInstanceContext computeNodeInstanceContext) throws SQLException {
        Map<String, ShardingSphereDatabase> changedDatabases = MetaDataContextsFactory.createChangedDatabases(databaseName, internalLoadMetaData, switchingResource, null, originalMetaDataContexts, metaDataPersistService, computeNodeInstanceContext);
        ConfigurationProperties props = originalMetaDataContexts.getMetaData().getProps();
        RuleMetaData changedGlobalMetaData = new RuleMetaData(GlobalRulesBuilder.buildRules((Collection)originalMetaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), changedDatabases, (ConfigurationProperties)props));
        return MetaDataContextsFactory.create(metaDataPersistService, new ShardingSphereMetaData(changedDatabases, originalMetaDataContexts.getMetaData().getGlobalResourceMetaData(), changedGlobalMetaData, props));
    }

    public static MetaDataContexts createByAlterRule(String databaseName, boolean internalLoadMetaData, Collection<RuleConfiguration> ruleConfigs, MetaDataContexts originalMetaDataContexts, MetaDataPersistService metaDataPersistService, ComputeNodeInstanceContext computeNodeInstanceContext) throws SQLException {
        Map<String, ShardingSphereDatabase> changedDatabases = MetaDataContextsFactory.createChangedDatabases(databaseName, internalLoadMetaData, null, ruleConfigs, originalMetaDataContexts, metaDataPersistService, computeNodeInstanceContext);
        ConfigurationProperties props = originalMetaDataContexts.getMetaData().getProps();
        RuleMetaData changedGlobalMetaData = new RuleMetaData(GlobalRulesBuilder.buildRules((Collection)originalMetaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), changedDatabases, (ConfigurationProperties)props));
        return MetaDataContextsFactory.create(metaDataPersistService, new ShardingSphereMetaData(changedDatabases, originalMetaDataContexts.getMetaData().getGlobalResourceMetaData(), changedGlobalMetaData, props));
    }

    public static Map<String, ShardingSphereDatabase> createChangedDatabases(String databaseName, boolean internalLoadMetaData, SwitchingResource switchingResource, Collection<RuleConfiguration> ruleConfigs, MetaDataContexts originalMetaDataContext, MetaDataPersistService metaDataPersistService, ComputeNodeInstanceContext computeNodeInstanceContext) throws SQLException {
        ResourceMetaData effectiveResourceMetaData = MetaDataContextsFactory.getEffectiveResourceMetaData(originalMetaDataContext.getMetaData().getDatabase(databaseName), switchingResource);
        Collection toBeCreatedRuleConfigs = null == ruleConfigs ? originalMetaDataContext.getMetaData().getDatabase(databaseName).getRuleMetaData().getConfigurations() : ruleConfigs;
        DatabaseConfiguration toBeCreatedDatabaseConfig = MetaDataContextsFactory.getDatabaseConfiguration(effectiveResourceMetaData, switchingResource, toBeCreatedRuleConfigs);
        ShardingSphereDatabase changedDatabase = MetaDataContextsFactory.createChangedDatabase(originalMetaDataContext.getMetaData().getDatabase(databaseName).getName(), internalLoadMetaData, metaDataPersistService, toBeCreatedDatabaseConfig, originalMetaDataContext.getMetaData().getProps(), computeNodeInstanceContext);
        LinkedHashMap<String, ShardingSphereDatabase> result = new LinkedHashMap<String, ShardingSphereDatabase>(originalMetaDataContext.getMetaData().getDatabases());
        result.put(databaseName.toLowerCase(), changedDatabase);
        return result;
    }

    private static ResourceMetaData getEffectiveResourceMetaData(ShardingSphereDatabase database, SwitchingResource resource) {
        Map<StorageNode, DataSource> storageNodes = MetaDataContextsFactory.getStorageNodes(database.getResourceMetaData().getDataSources(), resource);
        Map<String, StorageUnit> storageUnits = MetaDataContextsFactory.getStorageUnits(database.getResourceMetaData().getStorageUnits(), resource);
        return new ResourceMetaData(storageNodes, storageUnits);
    }

    private static Map<StorageNode, DataSource> getStorageNodes(Map<StorageNode, DataSource> currentStorageNodes, SwitchingResource resource) {
        LinkedHashMap<StorageNode, DataSource> result = new LinkedHashMap<StorageNode, DataSource>(currentStorageNodes.size(), 1.0f);
        for (Map.Entry<StorageNode, DataSource> entry : currentStorageNodes.entrySet()) {
            if (null != resource && resource.getStaleDataSources().containsKey(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static Map<String, StorageUnit> getStorageUnits(Map<String, StorageUnit> currentStorageUnits, SwitchingResource resource) {
        LinkedHashMap<String, StorageUnit> result = new LinkedHashMap<String, StorageUnit>(currentStorageUnits.size(), 1.0f);
        for (Map.Entry<String, StorageUnit> entry : currentStorageUnits.entrySet()) {
            if (null != resource && resource.getStaleStorageUnitNames().contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static DatabaseConfiguration getDatabaseConfiguration(ResourceMetaData resourceMetaData, SwitchingResource switchingResource, Collection<RuleConfiguration> toBeCreatedRuleConfigs) {
        Map propsMap = null == switchingResource ? (Map)resourceMetaData.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSourcePoolProperties(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)) : switchingResource.getMergedDataSourcePoolPropertiesMap();
        return new DataSourceProvidedDatabaseConfiguration(MetaDataContextsFactory.getMergedStorageNodeDataSources(resourceMetaData, switchingResource), toBeCreatedRuleConfigs, propsMap);
    }

    private static Map<StorageNode, DataSource> getMergedStorageNodeDataSources(ResourceMetaData currentResourceMetaData, SwitchingResource switchingResource) {
        Map result = currentResourceMetaData.getDataSources();
        if (null != switchingResource && !switchingResource.getNewDataSources().isEmpty()) {
            result.putAll(switchingResource.getNewDataSources());
        }
        return result;
    }

    private static ShardingSphereDatabase createChangedDatabase(String databaseName, boolean internalLoadMetaData, MetaDataPersistService persistService, DatabaseConfiguration databaseConfig, ConfigurationProperties props, ComputeNodeInstanceContext computeNodeInstanceContext) throws SQLException {
        return internalLoadMetaData ? InternalMetaDataFactory.create((String)databaseName, (MetaDataPersistService)persistService, (DatabaseConfiguration)databaseConfig, (ConfigurationProperties)props, (ComputeNodeInstanceContext)computeNodeInstanceContext) : ExternalMetaDataFactory.create((String)databaseName, (DatabaseConfiguration)databaseConfig, (ConfigurationProperties)props, (ComputeNodeInstanceContext)computeNodeInstanceContext);
    }

    @Generated
    private MetaDataContextsFactory() {
    }
}

