/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNodeAggregator;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnitNodeMapCreator;
import org.apache.shardingsphere.mode.metadata.manager.SwitchingResource;

public final class ResourceSwitchManager {
    public SwitchingResource switchByRegisterStorageUnit(ResourceMetaData resourceMetaData, Map<String, DataSourcePoolProperties> toBeRegisteredProps) {
        LinkedHashMap<String, DataSourcePoolProperties> mergedPropsMap = new LinkedHashMap<String, DataSourcePoolProperties>(resourceMetaData.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSourcePoolProperties(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
        mergedPropsMap.putAll(toBeRegisteredProps);
        Map toBeCreatedStorageUintNodeMap = StorageUnitNodeMapCreator.create(toBeRegisteredProps);
        Map dataSourcePoolPropsMap = StorageNodeAggregator.aggregateDataSourcePoolProperties(toBeRegisteredProps);
        return new SwitchingResource(this.getNewDataSources(resourceMetaData, toBeCreatedStorageUintNodeMap, dataSourcePoolPropsMap), Collections.emptyMap(), Collections.emptyList(), mergedPropsMap);
    }

    private Map<StorageNode, DataSource> getNewDataSources(ResourceMetaData resourceMetaData, Map<String, StorageNode> storageUintNodeMap, Map<StorageNode, DataSourcePoolProperties> dataSourcePoolPropsMap) {
        LinkedHashMap<StorageNode, DataSource> result = new LinkedHashMap<StorageNode, DataSource>(storageUintNodeMap.size(), 1.0f);
        for (StorageNode each : storageUintNodeMap.values()) {
            if (resourceMetaData.getDataSources().containsKey(each)) continue;
            result.put(each, DataSourcePoolCreator.create((DataSourcePoolProperties)dataSourcePoolPropsMap.get(each)));
        }
        return result;
    }

    public SwitchingResource switchByAlterStorageUnit(ResourceMetaData resourceMetaData, Map<String, DataSourcePoolProperties> toBeAlteredProps) {
        LinkedHashMap<String, DataSourcePoolProperties> mergedDataSourcePoolPropsMap = new LinkedHashMap<String, DataSourcePoolProperties>(resourceMetaData.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSourcePoolProperties(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
        mergedDataSourcePoolPropsMap.putAll(toBeAlteredProps);
        Map toBeAlteredStorageUintNodeMap = StorageUnitNodeMapCreator.create(mergedDataSourcePoolPropsMap);
        Map dataSourcePoolPropsMap = StorageNodeAggregator.aggregateDataSourcePoolProperties(mergedDataSourcePoolPropsMap);
        return new SwitchingResource(this.getAlterNewDataSources(toBeAlteredStorageUintNodeMap, dataSourcePoolPropsMap), this.getStaleDataSources(resourceMetaData, toBeAlteredStorageUintNodeMap.values()), new LinkedHashSet<String>(toBeAlteredStorageUintNodeMap.keySet()), mergedDataSourcePoolPropsMap);
    }

    private Map<StorageNode, DataSource> getAlterNewDataSources(Map<String, StorageNode> storageUintNodeMap, Map<StorageNode, DataSourcePoolProperties> dataSourcePoolPropsMap) {
        LinkedHashMap<StorageNode, DataSource> result = new LinkedHashMap<StorageNode, DataSource>(storageUintNodeMap.size(), 1.0f);
        for (StorageNode each : storageUintNodeMap.values()) {
            result.put(each, DataSourcePoolCreator.create((DataSourcePoolProperties)dataSourcePoolPropsMap.get(each)));
        }
        return result;
    }

    private Map<StorageNode, DataSource> getStaleDataSources(ResourceMetaData resourceMetaData, Collection<StorageNode> storageNodes) {
        LinkedHashMap<StorageNode, DataSource> result = new LinkedHashMap<StorageNode, DataSource>(storageNodes.size(), 1.0f);
        for (Map.Entry entry : resourceMetaData.getDataSources().entrySet()) {
            if (!storageNodes.contains(entry.getKey())) continue;
            result.put((StorageNode)entry.getKey(), (DataSource)entry.getValue());
        }
        return result;
    }

    public SwitchingResource switchByUnregisterStorageUnit(ResourceMetaData resourceMetaData, Collection<String> storageUnitNames) {
        LinkedHashMap<String, DataSourcePoolProperties> mergedDataSourcePoolPropertiesMap = new LinkedHashMap<String, DataSourcePoolProperties>(resourceMetaData.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSourcePoolProperties(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
        SwitchingResource result = new SwitchingResource(Collections.emptyMap(), this.getToBeRemovedStaleDataSource(resourceMetaData, storageUnitNames), storageUnitNames, mergedDataSourcePoolPropertiesMap);
        this.removeToBeRemovedStorageUnitNames(resourceMetaData, mergedDataSourcePoolPropertiesMap, storageUnitNames);
        return result;
    }

    private Map<StorageNode, DataSource> getToBeRemovedStaleDataSource(ResourceMetaData resourceMetaData, Collection<String> storageUnitNames) {
        LinkedHashMap<StorageNode, DataSource> result = new LinkedHashMap<StorageNode, DataSource>(storageUnitNames.size(), 1.0f);
        Map<String, StorageUnit> reservedStorageUnits = this.getReservedStorageUnits(resourceMetaData, storageUnitNames);
        for (String each : storageUnitNames) {
            StorageNode storageNode;
            if (!resourceMetaData.getStorageUnits().containsKey(each) || this.isStorageNodeInUsed(reservedStorageUnits, storageNode = ((StorageUnit)resourceMetaData.getStorageUnits().get(each)).getStorageNode())) continue;
            result.put(storageNode, (DataSource)resourceMetaData.getDataSources().get(storageNode));
        }
        return result;
    }

    private Map<String, StorageUnit> getReservedStorageUnits(ResourceMetaData resourceMetaData, Collection<String> storageUnitNames) {
        HashMap<String, StorageUnit> result = new HashMap<String, StorageUnit>(resourceMetaData.getStorageUnits());
        result.keySet().removeIf(storageUnitNames::contains);
        return result;
    }

    private boolean isStorageNodeInUsed(Map<String, StorageUnit> reservedStorageUnits, StorageNode storageNode) {
        return reservedStorageUnits.values().stream().anyMatch(each -> each.getStorageNode().equals((Object)storageNode));
    }

    private void removeToBeRemovedStorageUnitNames(ResourceMetaData resourceMetaData, Map<String, DataSourcePoolProperties> dataSourcePoolPropsMap, Collection<String> storageUnitNames) {
        for (String each : storageUnitNames) {
            dataSourcePoolPropsMap.remove(each);
            resourceMetaData.getStorageUnits().remove(each);
        }
    }
}

