/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.event.dispatch.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.manager.DatabaseRuleConfigurationManager;
import org.apache.shardingsphere.mode.spi.PersistRepository;
import org.apache.shardingsphere.mode.spi.RuleItemConfigurationChangedProcessor;

public class RuleItemManager {
    private final AtomicReference<MetaDataContexts> metaDataContexts;
    private final DatabaseRuleConfigurationManager ruleConfigurationManager;
    private final MetaDataPersistService metaDataPersistService;

    public RuleItemManager(AtomicReference<MetaDataContexts> metaDataContexts, PersistRepository repository, DatabaseRuleConfigurationManager ruleConfigurationManager) {
        this.metaDataContexts = metaDataContexts;
        this.ruleConfigurationManager = ruleConfigurationManager;
        this.metaDataPersistService = new MetaDataPersistService(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterRuleItem(AlterRuleItemEvent event) throws SQLException {
        Preconditions.checkArgument((boolean)event.getActiveVersion().equals(this.metaDataPersistService.getMetaDataVersionPersistService().getActiveVersionByFullPath(event.getActiveVersionKey())), (String)"Invalid active version: {} of key: {}", (Object)event.getActiveVersion(), (Object)event.getActiveVersionKey());
        RuleItemConfigurationChangedProcessor processor = (RuleItemConfigurationChangedProcessor)TypedSPILoader.getService(RuleItemConfigurationChangedProcessor.class, (Object)event.getType());
        String yamlContent = this.metaDataPersistService.getMetaDataVersionPersistService().getVersionPathByActiveVersion(event.getActiveVersionKey(), event.getActiveVersion());
        String databaseName = event.getDatabaseName();
        RuleConfiguration currentRuleConfig = processor.findRuleConfiguration(this.metaDataContexts.get().getMetaData().getDatabase(databaseName));
        RuleItemManager ruleItemManager = this;
        synchronized (ruleItemManager) {
            processor.changeRuleItemConfiguration(event, currentRuleConfig, processor.swapRuleItemConfiguration(event, yamlContent));
            this.ruleConfigurationManager.alterRuleConfiguration(databaseName, currentRuleConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropRuleItem(DropRuleItemEvent event) throws SQLException {
        String databaseName = event.getDatabaseName();
        Preconditions.checkState((boolean)this.metaDataContexts.get().getMetaData().containsDatabase(databaseName), (String)"No database '%s' exists.", (Object)databaseName);
        RuleItemConfigurationChangedProcessor processor = (RuleItemConfigurationChangedProcessor)TypedSPILoader.getService(RuleItemConfigurationChangedProcessor.class, (Object)event.getType());
        RuleConfiguration currentRuleConfig = processor.findRuleConfiguration(this.metaDataContexts.get().getMetaData().getDatabase(databaseName));
        RuleItemManager ruleItemManager = this;
        synchronized (ruleItemManager) {
            processor.dropRuleItemConfiguration(event, currentRuleConfig);
            this.ruleConfigurationManager.dropRuleConfiguration(databaseName, currentRuleConfig);
        }
    }
}

