/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.persist;

import lombok.Generated;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.MetaDataContextManager;
import org.apache.shardingsphere.mode.persist.service.ComputeNodePersistService;
import org.apache.shardingsphere.mode.persist.service.ListenerAssistedPersistService;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.mode.persist.service.PersistServiceBuilder;
import org.apache.shardingsphere.mode.persist.service.ProcessPersistService;
import org.apache.shardingsphere.mode.persist.service.QualifiedDataSourceStatePersistService;
import org.apache.shardingsphere.mode.persist.service.StatePersistService;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class PersistServiceFacade {
    private final PersistRepository repository;
    private final MetaDataPersistService metaDataPersistService;
    private final ComputeNodePersistService computeNodePersistService;
    private final StatePersistService statePersistService;
    private final MetaDataManagerPersistService metaDataManagerPersistService;
    private final ProcessPersistService processPersistService;
    private final ListenerAssistedPersistService listenerAssistedPersistService;
    private final QualifiedDataSourceStatePersistService qualifiedDataSourceStatePersistService;

    public PersistServiceFacade(PersistRepository repository, ModeConfiguration modeConfig, MetaDataContextManager metaDataContextManager) {
        this.repository = repository;
        this.metaDataPersistService = new MetaDataPersistService(repository);
        this.computeNodePersistService = new ComputeNodePersistService(repository);
        this.statePersistService = new StatePersistService(repository);
        this.qualifiedDataSourceStatePersistService = new QualifiedDataSourceStatePersistService(repository);
        PersistServiceBuilder persistServiceBuilder = (PersistServiceBuilder)TypedSPILoader.getService(PersistServiceBuilder.class, (Object)modeConfig.getType());
        this.metaDataManagerPersistService = persistServiceBuilder.buildMetaDataManagerPersistService(repository, metaDataContextManager);
        this.processPersistService = persistServiceBuilder.buildProcessPersistService(repository);
        this.listenerAssistedPersistService = new ListenerAssistedPersistService(repository);
    }

    @Generated
    public PersistRepository getRepository() {
        return this.repository;
    }

    @Generated
    public MetaDataPersistService getMetaDataPersistService() {
        return this.metaDataPersistService;
    }

    @Generated
    public ComputeNodePersistService getComputeNodePersistService() {
        return this.computeNodePersistService;
    }

    @Generated
    public StatePersistService getStatePersistService() {
        return this.statePersistService;
    }

    @Generated
    public MetaDataManagerPersistService getMetaDataManagerPersistService() {
        return this.metaDataManagerPersistService;
    }

    @Generated
    public ProcessPersistService getProcessPersistService() {
        return this.processPersistService;
    }

    @Generated
    public ListenerAssistedPersistService getListenerAssistedPersistService() {
        return this.listenerAssistedPersistService;
    }

    @Generated
    public QualifiedDataSourceStatePersistService getQualifiedDataSourceStatePersistService() {
        return this.qualifiedDataSourceStatePersistService;
    }
}

