/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.service.metadata.table;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlTableSwapper;
import org.apache.shardingsphere.metadata.persist.node.metadata.TableMetaDataNode;
import org.apache.shardingsphere.metadata.persist.service.version.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class TableMetaDataPersistService {
    private final PersistRepository repository;
    private final MetaDataVersionPersistService metaDataVersionPersistService;

    public Map<String, ShardingSphereTable> load(String databaseName, String schemaName) {
        List tableNames = this.repository.getChildrenKeys(TableMetaDataNode.getMetaDataTablesNode(databaseName, schemaName));
        return tableNames.stream().collect(Collectors.toMap(String::toLowerCase, each -> this.load(databaseName, schemaName, (String)each), (a, b) -> b, () -> new LinkedHashMap(tableNames.size(), 1.0f)));
    }

    public ShardingSphereTable load(String databaseName, String schemaName, String tableName) {
        String tableContent = this.repository.query(TableMetaDataNode.getTableVersionNode(databaseName, schemaName, tableName, this.repository.query(TableMetaDataNode.getTableActiveVersionNode(databaseName, schemaName, tableName))));
        return new YamlTableSwapper().swapToObject((YamlShardingSphereTable)YamlEngine.unmarshal((String)tableContent, YamlShardingSphereTable.class));
    }

    public void persist(String databaseName, String schemaName, Map<String, ShardingSphereTable> tables) {
        LinkedList<MetaDataVersion> metaDataVersions = new LinkedList<MetaDataVersion>();
        for (Map.Entry<String, ShardingSphereTable> entry : tables.entrySet()) {
            String nextActiveVersion;
            String tableName = entry.getKey().toLowerCase();
            List versions = this.repository.getChildrenKeys(TableMetaDataNode.getTableVersionsNode(databaseName, schemaName, tableName));
            String string = nextActiveVersion = versions.isEmpty() ? "0" : String.valueOf(Integer.parseInt((String)versions.get(0)) + 1);
            if (null != entry.getValue()) {
                this.repository.persist(TableMetaDataNode.getTableVersionNode(databaseName, schemaName, tableName, nextActiveVersion), YamlEngine.marshal((Object)new YamlTableSwapper().swapToYamlConfiguration(entry.getValue())));
            }
            if (Strings.isNullOrEmpty((String)this.getActiveVersion(databaseName, schemaName, tableName))) {
                this.repository.persist(TableMetaDataNode.getTableActiveVersionNode(databaseName, schemaName, tableName), "0");
            }
            metaDataVersions.add(new MetaDataVersion(TableMetaDataNode.getTableNode(databaseName, schemaName, tableName), this.getActiveVersion(databaseName, schemaName, tableName), nextActiveVersion));
        }
        this.metaDataVersionPersistService.switchActiveVersion(metaDataVersions);
    }

    private String getActiveVersion(String databaseName, String schemaName, String tableName) {
        return this.repository.query(TableMetaDataNode.getTableActiveVersionNode(databaseName, schemaName, tableName));
    }

    public void drop(String databaseName, String schemaName, String tableName) {
        this.repository.delete(TableMetaDataNode.getTableNode(databaseName, schemaName, tableName.toLowerCase()));
    }

    public void drop(String databaseName, String schemaName, Map<String, ShardingSphereTable> tables) {
        tables.forEach((key, value) -> this.drop(databaseName, schemaName, (String)key));
    }

    @Generated
    public TableMetaDataPersistService(PersistRepository repository, MetaDataVersionPersistService metaDataVersionPersistService) {
        this.repository = repository;
        this.metaDataVersionPersistService = metaDataVersionPersistService;
    }
}

