/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.reviser.schema;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.SchemaMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.TableMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.MetaDataReviseEntry;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.schema.SchemaTableAggregationReviser;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.table.TableMetaDataReviseEngine;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;

public final class SchemaMetaDataReviseEngine {
    private final Collection<ShardingSphereRule> rules;
    private final ConfigurationProperties props;
    private final DatabaseType databaseType;
    private final DataSource dataSource;

    public SchemaMetaData revise(SchemaMetaData originalMetaData) {
        SchemaMetaData result = originalMetaData;
        for (Map.Entry entry : OrderedSPILoader.getServices(MetaDataReviseEntry.class, this.rules).entrySet()) {
            result = this.revise(result, (ShardingSphereRule)entry.getKey(), (MetaDataReviseEntry)entry.getValue());
        }
        return result;
    }

    private <T extends ShardingSphereRule> SchemaMetaData revise(SchemaMetaData originalMetaData, T rule, MetaDataReviseEntry<T> reviseEntry) {
        TableMetaDataReviseEngine<T> tableMetaDataReviseEngine = new TableMetaDataReviseEngine<T>(rule, this.databaseType, this.dataSource, reviseEntry);
        Optional<SchemaTableAggregationReviser<T>> aggregationReviser = reviseEntry.getSchemaTableAggregationReviser(this.props);
        if (!aggregationReviser.isPresent()) {
            return new SchemaMetaData(originalMetaData.getName(), (Collection)originalMetaData.getTables().stream().map(tableMetaDataReviseEngine::revise).collect(Collectors.toList()));
        }
        for (TableMetaData each : originalMetaData.getTables()) {
            aggregationReviser.get().add(tableMetaDataReviseEngine.revise(each));
        }
        return new SchemaMetaData(originalMetaData.getName(), aggregationReviser.get().aggregate(rule));
    }

    @Generated
    public SchemaMetaDataReviseEngine(Collection<ShardingSphereRule> rules, ConfigurationProperties props, DatabaseType databaseType, DataSource dataSource) {
        this.rules = rules;
        this.props = props;
        this.databaseType = databaseType;
        this.dataSource = dataSource;
    }
}

