/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.metrics.core.exporter.impl.proxy;

import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.MetricsCollectorRegistry;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.type.GaugeMetricFamilyMetricsCollector;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricCollectorType;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricConfiguration;
import org.apache.shardingsphere.agent.plugin.metrics.core.exporter.MetricsExporter;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;

public final class ProxyMetaDataInfoExporter
implements MetricsExporter {
    private final MetricConfiguration config = new MetricConfiguration("proxy_meta_data_info", MetricCollectorType.GAUGE_METRIC_FAMILY, "Meta data information of ShardingSphere-Proxy. database_count is logic number of databases; storage_unit_count is number of storage units", Collections.singletonList("name"), Collections.emptyMap());

    @Override
    public Optional<GaugeMetricFamilyMetricsCollector> export(String pluginType) {
        if (null == ProxyContext.getInstance().getContextManager()) {
            return Optional.empty();
        }
        GaugeMetricFamilyMetricsCollector result = (GaugeMetricFamilyMetricsCollector)MetricsCollectorRegistry.get(this.config, pluginType);
        result.cleanMetrics();
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        result.addMetric(Collections.singletonList("database_count"), metaDataContexts.getMetaData().getDatabases().size());
        result.addMetric(Collections.singletonList("storage_unit_count"), this.getStorageUnitCount(metaDataContexts));
        return Optional.of(result);
    }

    private int getStorageUnitCount(MetaDataContexts metaDataContexts) {
        return metaDataContexts.getMetaData().getDatabases().values().stream().map(each -> each.getResourceMetaData().getStorageUnits().size()).reduce(0, Integer::sum);
    }
}

