/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLServerVersion {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLServerVersion.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+).*");
    private final int major;
    private final int minor;
    private final int series;

    public MySQLServerVersion(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            this.major = Short.parseShort(matcher.group(1));
            this.minor = Short.parseShort(matcher.group(2));
            this.series = Short.parseShort(matcher.group(3));
        } else {
            log.info("Could not match MySQL server version {}", (Object)version);
            this.major = 0;
            this.minor = 0;
            this.series = 0;
        }
    }

    public boolean greaterThanOrEqualTo(int major, int minor, int series) {
        if (this.major < major) {
            return false;
        }
        if (this.major > major) {
            return true;
        }
        if (this.minor < minor) {
            return false;
        }
        if (this.minor > minor) {
            return true;
        }
        return this.series >= series;
    }
}

