/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.converter;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodeUtils;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.expr.core.InlineExpressionParserFactory;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyLevelType;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.segment.strategy.AuditStrategySegment;
import org.apache.shardingsphere.sharding.distsql.segment.strategy.KeyGenerateStrategySegment;
import org.apache.shardingsphere.sharding.distsql.segment.strategy.ShardingAuditorSegment;
import org.apache.shardingsphere.sharding.distsql.segment.strategy.ShardingStrategySegment;
import org.apache.shardingsphere.sharding.distsql.segment.table.AbstractTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.segment.table.AutoTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.segment.table.TableRuleSegment;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public final class ShardingTableRuleStatementConverter {
    public static ShardingRuleConfiguration convert(Collection<AbstractTableRuleSegment> rules) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        for (AbstractTableRuleSegment each : rules) {
            result.getKeyGenerators().putAll(ShardingTableRuleStatementConverter.createKeyGeneratorConfiguration(each));
            result.getAuditors().putAll(ShardingTableRuleStatementConverter.createAuditorConfiguration(each));
            if (each instanceof AutoTableRuleSegment) {
                result.getShardingAlgorithms().putAll(ShardingTableRuleStatementConverter.createAlgorithmConfiguration((AutoTableRuleSegment)each));
                result.getAutoTables().add(ShardingTableRuleStatementConverter.createAutoTableRuleConfiguration((AutoTableRuleSegment)each));
            }
            if (!(each instanceof TableRuleSegment)) continue;
            result.getShardingAlgorithms().putAll(ShardingTableRuleStatementConverter.createAlgorithmConfiguration((TableRuleSegment)each));
            result.getTables().add(ShardingTableRuleStatementConverter.createTableRuleConfiguration((TableRuleSegment)each));
        }
        return result;
    }

    private static Map<String, AlgorithmConfiguration> createKeyGeneratorConfiguration(AbstractTableRuleSegment rule) {
        HashMap<String, AlgorithmConfiguration> result = new HashMap<String, AlgorithmConfiguration>();
        Optional.ofNullable(rule.getKeyGenerateStrategySegment()).ifPresent(optional -> result.put(ShardingTableRuleStatementConverter.getKeyGeneratorName(rule.getLogicTable(), optional.getKeyGenerateAlgorithmSegment().getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(optional.getKeyGenerateAlgorithmSegment())));
        return result;
    }

    private static Map<String, AlgorithmConfiguration> createAuditorConfiguration(AbstractTableRuleSegment rule) {
        HashMap<String, AlgorithmConfiguration> result = new HashMap<String, AlgorithmConfiguration>();
        Optional.ofNullable(rule.getAuditStrategySegment()).ifPresent(optional -> {
            for (ShardingAuditorSegment each : optional.getAuditorSegments()) {
                result.put(each.getAuditorName(), new AlgorithmConfiguration(each.getAlgorithmSegment().getName(), each.getAlgorithmSegment().getProps()));
            }
        });
        return result;
    }

    private static Map<String, AlgorithmConfiguration> createAlgorithmConfiguration(AutoTableRuleSegment rule) {
        HashMap<String, AlgorithmConfiguration> result = new HashMap<String, AlgorithmConfiguration>();
        Optional.ofNullable(rule.getShardingAlgorithmSegment()).ifPresent(optional -> result.put(ShardingTableRuleStatementConverter.getAutoTableShardingAlgorithmName(rule.getLogicTable(), optional.getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(optional)));
        return result;
    }

    private static Map<String, AlgorithmConfiguration> createAlgorithmConfiguration(TableRuleSegment rule) {
        HashMap<String, AlgorithmConfiguration> result = new HashMap<String, AlgorithmConfiguration>();
        if (null != rule.getTableStrategySegment()) {
            Optional.ofNullable(rule.getTableStrategySegment().getShardingAlgorithm()).ifPresent(optional -> result.put(ShardingTableRuleStatementConverter.getTableShardingAlgorithmName(rule.getLogicTable(), ShardingStrategyLevelType.TABLE, optional.getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(optional)));
        }
        if (null != rule.getDatabaseStrategySegment()) {
            Optional.ofNullable(rule.getDatabaseStrategySegment().getShardingAlgorithm()).ifPresent(optional -> result.put(ShardingTableRuleStatementConverter.getTableShardingAlgorithmName(rule.getLogicTable(), ShardingStrategyLevelType.DATABASE, optional.getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(optional)));
        }
        return result;
    }

    public static AlgorithmConfiguration createAlgorithmConfiguration(AlgorithmSegment segment) {
        return new AlgorithmConfiguration(segment.getName().toLowerCase(), segment.getProps());
    }

    private static ShardingAutoTableRuleConfiguration createAutoTableRuleConfiguration(AutoTableRuleSegment rule) {
        ShardingAutoTableRuleConfiguration result = new ShardingAutoTableRuleConfiguration(rule.getLogicTable(), String.join((CharSequence)",", rule.getDataSourceNodes()));
        result.setShardingStrategy(ShardingTableRuleStatementConverter.createAutoTableStrategyConfiguration(rule));
        Optional.ofNullable(rule.getKeyGenerateStrategySegment()).ifPresent(optional -> result.setKeyGenerateStrategy(ShardingTableRuleStatementConverter.createKeyGenerateStrategyConfiguration(rule.getLogicTable(), rule.getKeyGenerateStrategySegment())));
        Optional.ofNullable(rule.getAuditStrategySegment()).ifPresent(optional -> result.setAuditStrategy(ShardingTableRuleStatementConverter.createShardingAuditStrategyConfiguration(rule.getAuditStrategySegment())));
        return result;
    }

    private static ShardingStrategyConfiguration createAutoTableStrategyConfiguration(AutoTableRuleSegment rule) {
        return ShardingTableRuleStatementConverter.createStrategyConfiguration(ShardingStrategyType.STANDARD.name(), rule.getShardingColumn(), ShardingTableRuleStatementConverter.getAutoTableShardingAlgorithmName(rule.getLogicTable(), rule.getShardingAlgorithmSegment().getName()));
    }

    private static ShardingTableRuleConfiguration createTableRuleConfiguration(TableRuleSegment tableRuleSegment) {
        String dataSourceNodes = String.join((CharSequence)",", tableRuleSegment.getDataSourceNodes());
        ShardingTableRuleConfiguration result = new ShardingTableRuleConfiguration(tableRuleSegment.getLogicTable(), dataSourceNodes);
        Optional.ofNullable(tableRuleSegment.getTableStrategySegment()).ifPresent(optional -> result.setTableShardingStrategy(ShardingTableRuleStatementConverter.createShardingStrategyConfiguration(tableRuleSegment.getLogicTable(), ShardingStrategyLevelType.TABLE, optional.getType(), optional)));
        Optional.ofNullable(tableRuleSegment.getDatabaseStrategySegment()).ifPresent(optional -> result.setDatabaseShardingStrategy(ShardingTableRuleStatementConverter.createShardingStrategyConfiguration(tableRuleSegment.getLogicTable(), ShardingStrategyLevelType.DATABASE, optional.getType(), optional)));
        Optional.ofNullable(tableRuleSegment.getKeyGenerateStrategySegment()).ifPresent(optional -> result.setKeyGenerateStrategy(ShardingTableRuleStatementConverter.createKeyGenerateStrategyConfiguration(tableRuleSegment.getLogicTable(), optional)));
        Optional.ofNullable(tableRuleSegment.getAuditStrategySegment()).ifPresent(optional -> result.setAuditStrategy(ShardingTableRuleStatementConverter.createShardingAuditStrategyConfiguration(optional)));
        return result;
    }

    private static ShardingStrategyConfiguration createShardingStrategyConfiguration(String logicTable, ShardingStrategyLevelType strategyLevel, String type, ShardingStrategySegment segment) {
        if ("none".equalsIgnoreCase(type)) {
            return new NoneShardingStrategyConfiguration();
        }
        String shardingAlgorithmName = ShardingTableRuleStatementConverter.getTableShardingAlgorithmName(logicTable, strategyLevel, segment.getShardingAlgorithm().getName());
        return ShardingTableRuleStatementConverter.createStrategyConfiguration(ShardingStrategyType.getValueOf(type).name(), segment.getShardingColumn(), shardingAlgorithmName);
    }

    private static KeyGenerateStrategyConfiguration createKeyGenerateStrategyConfiguration(String logicTable, KeyGenerateStrategySegment segment) {
        return new KeyGenerateStrategyConfiguration(segment.getKeyGenerateColumn(), ShardingTableRuleStatementConverter.getKeyGeneratorName(logicTable, segment.getKeyGenerateAlgorithmSegment().getName()));
    }

    private static ShardingAuditStrategyConfiguration createShardingAuditStrategyConfiguration(AuditStrategySegment segment) {
        Collection auditorNames = segment.getAuditorSegments().stream().map(ShardingAuditorSegment::getAuditorName).collect(Collectors.toList());
        return new ShardingAuditStrategyConfiguration(auditorNames, segment.isAllowHintDisable());
    }

    public static ShardingStrategyConfiguration createStrategyConfiguration(String strategyType, String shardingColumn, String shardingAlgorithmName) {
        ShardingStrategyType shardingStrategyType = ShardingStrategyType.getValueOf(strategyType);
        return shardingStrategyType.createConfiguration(shardingAlgorithmName, shardingColumn);
    }

    private static String getAutoTableShardingAlgorithmName(String tableName, String algorithmType) {
        return String.format("%s_%s", tableName, algorithmType).toLowerCase();
    }

    private static String getTableShardingAlgorithmName(String tableName, ShardingStrategyLevelType strategyLevel, String algorithmType) {
        return String.format("%s_%s_%s", tableName, strategyLevel.name(), algorithmType).toLowerCase();
    }

    private static String getKeyGeneratorName(String tableName, String algorithmType) {
        return String.format("%s_%s", tableName, algorithmType).toLowerCase();
    }

    public static Map<String, Collection<DataNode>> convertDataNodes(Collection<AbstractTableRuleSegment> segments) {
        HashMap<String, Collection<DataNode>> result = new HashMap<String, Collection<DataNode>>(segments.size(), 1.0f);
        for (AbstractTableRuleSegment each : segments) {
            if (each instanceof TableRuleSegment) {
                result.put(each.getLogicTable(), ShardingTableRuleStatementConverter.getActualDataNodes((TableRuleSegment)each));
                continue;
            }
            result.put(each.getLogicTable(), ShardingTableRuleStatementConverter.getActualDataNodes((AutoTableRuleSegment)each));
        }
        return result;
    }

    private static Collection<DataNode> getActualDataNodes(TableRuleSegment ruleSegment) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : ruleSegment.getDataSourceNodes()) {
            List dataNodes = InlineExpressionParserFactory.newInstance((String)each).splitAndEvaluate();
            result.addAll(dataNodes.stream().map(DataNode::new).collect(Collectors.toList()));
        }
        return result;
    }

    private static Collection<DataNode> getActualDataNodes(AutoTableRuleSegment ruleSegment) {
        ShardingAlgorithm shardingAlgorithm = (ShardingAlgorithm)TypedSPILoader.getService(ShardingAlgorithm.class, (Object)ruleSegment.getShardingAlgorithmSegment().getName(), (Properties)ruleSegment.getShardingAlgorithmSegment().getProps());
        ShardingSpherePreconditions.checkState((boolean)(shardingAlgorithm instanceof ShardingAutoTableAlgorithm), () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)shardingAlgorithm, "Auto sharding algorithm is required for table '%s'", new Object[]{ruleSegment.getLogicTable()}));
        List dataNodes = DataNodeUtils.getFormatDataNodes((int)((ShardingAutoTableAlgorithm)shardingAlgorithm).getAutoTablesAmount(), (String)ruleSegment.getLogicTable(), (Collection)ruleSegment.getDataSourceNodes());
        return dataNodes.stream().map(DataNode::new).collect(Collectors.toList());
    }

    @Generated
    private ShardingTableRuleStatementConverter() {
    }
}

