/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.RoutineBodySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.ValidStatementSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.datetime.DatetimeExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CaseWhenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CollateExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExistsSubqueryExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.NotExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.TypeCastExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerAvailable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.match.MatchAgainstExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.DeleteMultiTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;

public final class TableExtractor {
    private final Collection<SimpleTableSegment> rewriteTables = new LinkedList<SimpleTableSegment>();
    private final Collection<TableSegment> tableContext = new LinkedList<TableSegment>();
    private final Collection<JoinTableSegment> joinTables = new LinkedList<JoinTableSegment>();

    public void extractTablesFromSelect(SelectStatement selectStatement) {
        if (selectStatement.getCombine().isPresent()) {
            CombineSegment combineSegment = selectStatement.getCombine().get();
            this.extractTablesFromSelect(combineSegment.getLeft().getSelect());
            this.extractTablesFromSelect(combineSegment.getRight().getSelect());
        }
        if (selectStatement.getFrom().isPresent() && !selectStatement.getCombine().isPresent()) {
            this.extractTablesFromTableSegment(selectStatement.getFrom().get());
        }
        selectStatement.getWhere().ifPresent(optional -> this.extractTablesFromExpression(optional.getExpr()));
        if (null != selectStatement.getProjections() && !selectStatement.getCombine().isPresent()) {
            this.extractTablesFromProjections(selectStatement.getProjections());
        }
        selectStatement.getGroupBy().ifPresent(optional -> this.extractTablesFromOrderByItems(optional.getGroupByItems()));
        selectStatement.getOrderBy().ifPresent(optional -> this.extractTablesFromOrderByItems(optional.getOrderByItems()));
        selectStatement.getHaving().ifPresent(optional -> this.extractTablesFromExpression(optional.getExpr()));
        selectStatement.getWithSegment().ifPresent(optional -> this.extractTablesFromCTEs(optional.getCommonTableExpressions()));
        selectStatement.getLock().ifPresent(this::extractTablesFromLock);
    }

    private void extractTablesFromCTEs(Collection<CommonTableExpressionSegment> commonTableExpressionSegments) {
        for (CommonTableExpressionSegment each : commonTableExpressionSegments) {
            this.extractTablesFromSelect(each.getSubquery().getSelect());
        }
    }

    private void extractTablesFromTableSegment(TableSegment tableSegment) {
        if (tableSegment instanceof SimpleTableSegment) {
            this.tableContext.add(tableSegment);
            this.rewriteTables.add((SimpleTableSegment)tableSegment);
        }
        if (tableSegment instanceof SubqueryTableSegment) {
            this.tableContext.add(tableSegment);
            TableExtractor tableExtractor = new TableExtractor();
            tableExtractor.extractTablesFromSelect(((SubqueryTableSegment)tableSegment).getSubquery().getSelect());
            this.rewriteTables.addAll(tableExtractor.rewriteTables);
            this.joinTables.addAll(tableExtractor.joinTables);
        }
        if (tableSegment instanceof JoinTableSegment) {
            this.joinTables.add((JoinTableSegment)tableSegment);
            this.extractTablesFromJoinTableSegment((JoinTableSegment)tableSegment);
        }
        if (tableSegment instanceof DeleteMultiTableSegment) {
            DeleteMultiTableSegment deleteMultiTableSegment = (DeleteMultiTableSegment)tableSegment;
            this.rewriteTables.addAll(deleteMultiTableSegment.getActualDeleteTables());
            this.extractTablesFromTableSegment(deleteMultiTableSegment.getRelationTable());
        }
    }

    private void extractTablesFromJoinTableSegment(JoinTableSegment tableSegment) {
        this.extractTablesFromTableSegment(tableSegment.getLeft());
        this.extractTablesFromTableSegment(tableSegment.getRight());
        this.extractTablesFromExpression(tableSegment.getCondition());
    }

    private void extractTablesFromExpression(ExpressionSegment expressionSegment) {
        if (expressionSegment instanceof ColumnSegment) {
            this.extractTablesFromColumnSegments(Collections.singleton((ColumnSegment)expressionSegment));
        }
        if (expressionSegment instanceof ListExpression) {
            ((ListExpression)expressionSegment).getItems().forEach(this::extractTablesFromExpression);
        }
        if (expressionSegment instanceof ExistsSubqueryExpression) {
            this.extractTablesFromSelect(((ExistsSubqueryExpression)expressionSegment).getSubquery().getSelect());
        }
        if (expressionSegment instanceof BetweenExpression) {
            this.extractTablesFromExpression(((BetweenExpression)expressionSegment).getLeft());
            this.extractTablesFromExpression(((BetweenExpression)expressionSegment).getBetweenExpr());
            this.extractTablesFromExpression(((BetweenExpression)expressionSegment).getAndExpr());
        }
        if (expressionSegment instanceof InExpression) {
            this.extractTablesFromExpression(((InExpression)expressionSegment).getLeft());
            this.extractTablesFromExpression(((InExpression)expressionSegment).getRight());
        }
        if (expressionSegment instanceof SubqueryExpressionSegment) {
            this.extractTablesFromSelect(((SubqueryExpressionSegment)expressionSegment).getSubquery().getSelect());
        }
        if (expressionSegment instanceof SubquerySegment) {
            this.extractTablesFromSelect(((SubquerySegment)expressionSegment).getSelect());
        }
        if (expressionSegment instanceof BinaryOperationExpression) {
            this.extractTablesFromExpression(((BinaryOperationExpression)expressionSegment).getLeft());
            this.extractTablesFromExpression(((BinaryOperationExpression)expressionSegment).getRight());
        }
        if (expressionSegment instanceof MatchAgainstExpression) {
            ((MatchAgainstExpression)expressionSegment).getColumns().forEach(this::extractTablesFromExpression);
            this.extractTablesFromExpression(((MatchAgainstExpression)expressionSegment).getExpr());
        }
        if (expressionSegment instanceof FunctionSegment) {
            ((FunctionSegment)expressionSegment).getParameters().forEach(this::extractTablesFromExpression);
        }
        if (expressionSegment instanceof CaseWhenExpression) {
            this.extractTablesFromCaseWhenExpression((CaseWhenExpression)expressionSegment);
        }
        if (expressionSegment instanceof CollateExpression) {
            this.extractTablesFromExpression(((CollateExpression)expressionSegment).getCollateName());
        }
        if (expressionSegment instanceof DatetimeExpression) {
            this.extractTablesFromExpression(((DatetimeExpression)expressionSegment).getLeft());
            this.extractTablesFromExpression(((DatetimeExpression)expressionSegment).getRight());
        }
        if (expressionSegment instanceof NotExpression) {
            this.extractTablesFromExpression(((NotExpression)expressionSegment).getExpression());
        }
        if (expressionSegment instanceof TypeCastExpression) {
            this.extractTablesFromExpression(((TypeCastExpression)expressionSegment).getExpression());
        }
    }

    private void extractTablesFromCaseWhenExpression(CaseWhenExpression expressionSegment) {
        this.extractTablesFromExpression(expressionSegment.getCaseExpr());
        expressionSegment.getWhenExprs().forEach(this::extractTablesFromExpression);
        expressionSegment.getThenExprs().forEach(this::extractTablesFromExpression);
        this.extractTablesFromExpression(expressionSegment.getElseExpr());
    }

    private void extractTablesFromProjections(ProjectionsSegment projections) {
        for (ProjectionSegment each : projections.getProjections()) {
            OwnerSegment ownerSegment;
            if (each instanceof SubqueryProjectionSegment) {
                this.extractTablesFromSelect(((SubqueryProjectionSegment)each).getSubquery().getSelect());
                continue;
            }
            if (each instanceof OwnerAvailable) {
                if (!((OwnerAvailable)((Object)each)).getOwner().isPresent() || !this.needRewrite(((OwnerAvailable)((Object)each)).getOwner().get())) continue;
                ownerSegment = ((OwnerAvailable)((Object)each)).getOwner().get();
                this.rewriteTables.add(this.createSimpleTableSegment(ownerSegment));
                continue;
            }
            if (each instanceof ColumnProjectionSegment) {
                if (!((ColumnProjectionSegment)each).getColumn().getOwner().isPresent() || !this.needRewrite(((ColumnProjectionSegment)each).getColumn().getOwner().get())) continue;
                ownerSegment = ((ColumnProjectionSegment)each).getColumn().getOwner().get();
                this.rewriteTables.add(this.createSimpleTableSegment(ownerSegment));
                continue;
            }
            if (each instanceof AggregationProjectionSegment) {
                ((AggregationProjectionSegment)each).getParameters().forEach(this::extractTablesFromExpression);
                continue;
            }
            if (!(each instanceof ExpressionProjectionSegment)) continue;
            this.extractTablesFromExpression(((ExpressionProjectionSegment)each).getExpr());
        }
    }

    private SimpleTableSegment createSimpleTableSegment(OwnerSegment ownerSegment) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ownerSegment.getStartIndex(), ownerSegment.getStopIndex(), ownerSegment.getIdentifier()));
        ownerSegment.getOwner().ifPresent(result::setOwner);
        return result;
    }

    private void extractTablesFromOrderByItems(Collection<OrderByItemSegment> orderByItems) {
        for (OrderByItemSegment each : orderByItems) {
            Optional<OwnerSegment> owner;
            if (!(each instanceof ColumnOrderByItemSegment) || !(owner = ((ColumnOrderByItemSegment)each).getColumn().getOwner()).isPresent() || !this.needRewrite(owner.get())) continue;
            this.rewriteTables.add(new SimpleTableSegment(new TableNameSegment(owner.get().getStartIndex(), owner.get().getStopIndex(), owner.get().getIdentifier())));
        }
    }

    private void extractTablesFromLock(LockSegment lockSegment) {
        this.rewriteTables.addAll(lockSegment.getTables());
    }

    public void extractTablesFromDelete(DeleteStatement deleteStatement) {
        this.extractTablesFromTableSegment(deleteStatement.getTable());
        if (deleteStatement.getWhere().isPresent()) {
            this.extractTablesFromExpression(deleteStatement.getWhere().get().getExpr());
        }
    }

    public void extractTablesFromInsert(InsertStatement insertStatement) {
        insertStatement.getTable().ifPresent(this::extractTablesFromTableSegment);
        if (!insertStatement.getColumns().isEmpty()) {
            for (ColumnSegment each : insertStatement.getColumns()) {
                this.extractTablesFromExpression(each);
            }
        }
        insertStatement.getOnDuplicateKeyColumns().ifPresent(optional -> this.extractTablesFromAssignmentItems(optional.getColumns()));
        if (insertStatement.getInsertSelect().isPresent()) {
            this.extractTablesFromSelect(insertStatement.getInsertSelect().get().getSelect());
        }
    }

    private void extractTablesFromAssignmentItems(Collection<ColumnAssignmentSegment> assignmentItems) {
        assignmentItems.forEach(each -> this.extractTablesFromColumnSegments(each.getColumns()));
    }

    private void extractTablesFromColumnSegments(Collection<ColumnSegment> columnSegments) {
        for (ColumnSegment each : columnSegments) {
            if (!each.getOwner().isPresent() || !this.needRewrite(each.getOwner().get())) continue;
            OwnerSegment ownerSegment = each.getOwner().get();
            this.rewriteTables.add(new SimpleTableSegment(new TableNameSegment(ownerSegment.getStartIndex(), ownerSegment.getStopIndex(), ownerSegment.getIdentifier())));
        }
    }

    public void extractTablesFromUpdate(UpdateStatement updateStatement) {
        this.extractTablesFromTableSegment(updateStatement.getTable());
        updateStatement.getSetAssignment().getAssignments().forEach(each -> this.extractTablesFromExpression(each.getColumns().get(0)));
        if (updateStatement.getWhere().isPresent()) {
            this.extractTablesFromExpression(updateStatement.getWhere().get().getExpr());
        }
    }

    public boolean needRewrite(OwnerSegment owner) {
        for (TableSegment each : this.tableContext) {
            if (!owner.getIdentifier().getValue().equalsIgnoreCase(each.getAliasName().orElse(null))) continue;
            return false;
        }
        return true;
    }

    public Collection<SimpleTableSegment> extractExistTableFromRoutineBody(RoutineBodySegment routineBody) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (ValidStatementSegment each : routineBody.getValidStatements()) {
            if (each.getAlterTable().isPresent()) {
                result.add(each.getAlterTable().get().getTable());
            }
            if (each.getDropTable().isPresent()) {
                result.addAll(each.getDropTable().get().getTables());
            }
            if (each.getTruncate().isPresent()) {
                result.addAll(each.getTruncate().get().getTables());
            }
            result.addAll(this.extractExistTableFromDMLStatement(each));
        }
        return result;
    }

    private Collection<SimpleTableSegment> extractExistTableFromDMLStatement(ValidStatementSegment validStatementSegment) {
        if (validStatementSegment.getInsert().isPresent()) {
            this.extractTablesFromInsert(validStatementSegment.getInsert().get());
        } else if (validStatementSegment.getReplace().isPresent()) {
            this.extractTablesFromInsert(validStatementSegment.getReplace().get());
        } else if (validStatementSegment.getUpdate().isPresent()) {
            this.extractTablesFromUpdate(validStatementSegment.getUpdate().get());
        } else if (validStatementSegment.getDelete().isPresent()) {
            this.extractTablesFromDelete(validStatementSegment.getDelete().get());
        } else if (validStatementSegment.getSelect().isPresent()) {
            this.extractTablesFromSelect(validStatementSegment.getSelect().get());
        }
        return this.rewriteTables;
    }

    public Collection<SimpleTableSegment> extractNotExistTableFromRoutineBody(RoutineBodySegment routineBody) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (ValidStatementSegment each : routineBody.getValidStatements()) {
            Optional<CreateTableStatement> createTable = each.getCreateTable();
            if (!createTable.isPresent() || createTable.get().isIfNotExists()) continue;
            result.add(createTable.get().getTable());
        }
        return result;
    }

    public void extractTablesFromSQLStatement(SQLStatement sqlStatement) {
        if (sqlStatement instanceof SelectStatement) {
            this.extractTablesFromSelect((SelectStatement)sqlStatement);
        } else if (sqlStatement instanceof InsertStatement) {
            this.extractTablesFromInsert((InsertStatement)sqlStatement);
        } else if (sqlStatement instanceof UpdateStatement) {
            this.extractTablesFromUpdate((UpdateStatement)sqlStatement);
        } else if (sqlStatement instanceof DeleteStatement) {
            this.extractTablesFromDelete((DeleteStatement)sqlStatement);
        }
    }

    public void extractTablesFromCreateViewStatement(CreateViewStatement createViewStatement) {
        this.tableContext.add(createViewStatement.getView());
        this.rewriteTables.add(createViewStatement.getView());
        this.extractTablesFromSelect(createViewStatement.getSelect());
    }

    @Generated
    public Collection<SimpleTableSegment> getRewriteTables() {
        return this.rewriteTables;
    }

    @Generated
    public Collection<TableSegment> getTableContext() {
        return this.tableContext;
    }

    @Generated
    public Collection<JoinTableSegment> getJoinTables() {
        return this.joinTables;
    }
}

