/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import java.util.Properties;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.distsql.statement.ral.updatable.LockClusterStatement;
import org.apache.shardingsphere.infra.algorithm.core.exception.MissingRequiredAlgorithmException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.lock.GlobalLockNames;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.lock.LockDefinition;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.state.cluster.ClusterState;
import org.apache.shardingsphere.mode.exception.LockedClusterException;
import org.apache.shardingsphere.mode.lock.GlobalLockDefinition;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.lock.spi.ClusterLockStrategy;

@DistSQLExecutorClusterModeRequired
public final class LockClusterExecutor
implements DistSQLUpdateExecutor<LockClusterStatement> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(LockClusterStatement sqlStatement, ContextManager contextManager) {
        this.checkState(contextManager);
        this.checkAlgorithm(sqlStatement);
        LockContext lockContext = contextManager.getComputeNodeInstanceContext().getLockContext();
        GlobalLockDefinition lockDefinition = new GlobalLockDefinition(GlobalLockNames.CLUSTER_LOCK.getLockName());
        if (lockContext.tryLock((LockDefinition)lockDefinition, 3000L)) {
            try {
                this.checkState(contextManager);
                ((ClusterLockStrategy)TypedSPILoader.getService(ClusterLockStrategy.class, (Object)sqlStatement.getLockStrategy().getName())).lock();
            }
            finally {
                lockContext.unlock((LockDefinition)lockDefinition);
            }
        }
    }

    private void checkState(ContextManager contextManager) {
        ShardingSpherePreconditions.checkState((ClusterState.OK == contextManager.getStateContext().getClusterState() ? 1 : 0) != 0, LockedClusterException::new);
    }

    private void checkAlgorithm(LockClusterStatement sqlStatement) {
        ShardingSpherePreconditions.checkNotNull((Object)sqlStatement.getLockStrategy(), () -> new MissingRequiredAlgorithmException("Lock", new SQLExceptionIdentifier("")));
        TypedSPILoader.checkService(ClusterLockStrategy.class, (Object)sqlStatement.getLockStrategy().getName(), (Properties)sqlStatement.getLockStrategy().getProps());
    }

    public Class<LockClusterStatement> getType() {
        return LockClusterStatement.class;
    }
}

