/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.statement.ral.updatable.RefreshTableMetaDataStatement;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.EmptyStorageUnitException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.MissingRequiredStorageUnitsException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class RefreshTableMetaDataExecutor
implements DistSQLUpdateExecutor<RefreshTableMetaDataStatement>,
DistSQLExecutorDatabaseAware {
    private ShardingSphereDatabase database;

    public void executeUpdate(RefreshTableMetaDataStatement sqlStatement, ContextManager contextManager) throws SQLException {
        this.checkStorageUnit(contextManager.getStorageUnits(this.database.getName()), sqlStatement);
        String schemaName = this.getSchemaName(sqlStatement);
        if (sqlStatement.getStorageUnitName().isPresent()) {
            if (sqlStatement.getTableName().isPresent()) {
                contextManager.reloadTable(this.database, schemaName, (String)sqlStatement.getStorageUnitName().get(), (String)sqlStatement.getTableName().get());
            } else {
                contextManager.reloadSchema(this.database, schemaName, (String)sqlStatement.getStorageUnitName().get());
            }
            return;
        }
        if (sqlStatement.getTableName().isPresent()) {
            contextManager.reloadTable(this.database, schemaName, (String)sqlStatement.getTableName().get());
        } else {
            contextManager.getMetaDataContextManager().refreshTableMetaData(this.database);
        }
    }

    private void checkStorageUnit(Map<String, StorageUnit> storageUnits, RefreshTableMetaDataStatement sqlStatement) {
        ShardingSpherePreconditions.checkNotEmpty(storageUnits, () -> new EmptyStorageUnitException(this.database.getName()));
        if (sqlStatement.getStorageUnitName().isPresent()) {
            String storageUnitName = (String)sqlStatement.getStorageUnitName().get();
            ShardingSpherePreconditions.checkContainsKey(storageUnits, (Object)storageUnitName, () -> new MissingRequiredStorageUnitsException(this.database.getName(), Collections.singleton(storageUnitName)));
        }
    }

    private String getSchemaName(RefreshTableMetaDataStatement sqlStatement) {
        return sqlStatement.getSchemaName().isPresent() ? (String)sqlStatement.getSchemaName().get() : new DatabaseTypeRegistry(this.database.getProtocolType()).getDefaultSchemaName(this.database.getName());
    }

    public Class<RefreshTableMetaDataStatement> getType() {
        return RefreshTableMetaDataStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }
}

