/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.distsql.statement.ral.updatable.UnlockClusterStatement;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.lock.GlobalLockNames;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.lock.LockDefinition;
import org.apache.shardingsphere.infra.state.cluster.ClusterState;
import org.apache.shardingsphere.mode.exception.NotLockedClusterException;
import org.apache.shardingsphere.mode.lock.GlobalLockDefinition;
import org.apache.shardingsphere.mode.manager.ContextManager;

@DistSQLExecutorClusterModeRequired
public final class UnlockClusterExecutor
implements DistSQLUpdateExecutor<UnlockClusterStatement> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(UnlockClusterStatement sqlStatement, ContextManager contextManager) {
        this.checkState(contextManager);
        LockContext lockContext = contextManager.getComputeNodeInstanceContext().getLockContext();
        GlobalLockDefinition lockDefinition = new GlobalLockDefinition(GlobalLockNames.CLUSTER_LOCK.getLockName());
        if (lockContext.tryLock((LockDefinition)lockDefinition, 3000L)) {
            try {
                this.checkState(contextManager);
                contextManager.getPersistServiceFacade().getStatePersistService().update(ClusterState.OK);
            }
            finally {
                lockContext.unlock((LockDefinition)lockDefinition);
            }
        }
    }

    private void checkState(ContextManager contextManager) {
        ShardingSpherePreconditions.checkState((ClusterState.OK != contextManager.getStateContext().getClusterState() ? 1 : 0) != 0, NotLockedClusterException::new);
    }

    public Class<UnlockClusterStatement> getType() {
        return UnlockClusterStatement.class;
    }
}

