/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.config;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.encrypt.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptColumnItemRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.exception.metadata.MissingRequiredEncryptColumnException;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.MissingRequiredAlgorithmException;
import org.apache.shardingsphere.infra.algorithm.core.exception.UnregisteredAlgorithmException;
import org.apache.shardingsphere.infra.config.rule.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class EncryptRuleConfigurationChecker
implements RuleConfigurationChecker<EncryptRuleConfiguration> {
    public void check(String databaseName, EncryptRuleConfiguration ruleConfig, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        this.checkEncryptors(ruleConfig.getEncryptors());
        this.checkTables(databaseName, ruleConfig.getTables(), ruleConfig.getEncryptors());
    }

    private void checkEncryptors(Map<String, AlgorithmConfiguration> encryptors) {
        encryptors.values().forEach(each -> TypedSPILoader.checkService(EncryptAlgorithm.class, (Object)each.getType(), (Properties)each.getProps()));
    }

    private void checkTables(String databaseName, Collection<EncryptTableRuleConfiguration> tableRuleConfigs, Map<String, AlgorithmConfiguration> encryptors) {
        tableRuleConfigs.forEach(each -> this.checkColumns(databaseName, (EncryptTableRuleConfiguration)each, encryptors));
    }

    private void checkColumns(String databaseName, EncryptTableRuleConfiguration tableRuleConfig, Map<String, AlgorithmConfiguration> encryptors) {
        tableRuleConfig.getColumns().forEach(each -> this.checkColumn(databaseName, tableRuleConfig.getName(), (EncryptColumnRuleConfiguration)each, encryptors));
    }

    private void checkColumn(String databaseName, String tableName, EncryptColumnRuleConfiguration columnRuleConfig, Map<String, AlgorithmConfiguration> encryptors) {
        this.checkCipherColumn(databaseName, tableName, columnRuleConfig.getName(), columnRuleConfig.getCipher(), encryptors);
        columnRuleConfig.getAssistedQuery().ifPresent(optional -> this.checkAssistColumn(databaseName, tableName, columnRuleConfig.getName(), (EncryptColumnItemRuleConfiguration)optional, encryptors));
        columnRuleConfig.getLikeQuery().ifPresent(optional -> this.checkLikeColumn(databaseName, tableName, columnRuleConfig.getName(), (EncryptColumnItemRuleConfiguration)optional, encryptors));
    }

    private void checkCipherColumn(String databaseName, String tableName, String logicColumnName, EncryptColumnItemRuleConfiguration cipherColumnConfig, Map<String, AlgorithmConfiguration> encryptors) {
        ShardingSpherePreconditions.checkNotEmpty((String)cipherColumnConfig.getName(), () -> new MissingRequiredEncryptColumnException("Cipher", new SQLExceptionIdentifier(databaseName, tableName, logicColumnName)));
        ShardingSpherePreconditions.checkNotEmpty((String)cipherColumnConfig.getEncryptorName(), () -> new MissingRequiredAlgorithmException("Standard encrypt", new SQLExceptionIdentifier(databaseName, tableName, logicColumnName)));
        ShardingSpherePreconditions.checkContainsKey(encryptors, (Object)cipherColumnConfig.getEncryptorName(), () -> new UnregisteredAlgorithmException("Standard encrypt", cipherColumnConfig.getEncryptorName(), new SQLExceptionIdentifier(databaseName, tableName, logicColumnName)));
    }

    private void checkAssistColumn(String databaseName, String tableName, String logicColumnName, EncryptColumnItemRuleConfiguration assistedQueryColumnConfig, Map<String, AlgorithmConfiguration> encryptors) {
        ShardingSpherePreconditions.checkNotEmpty((String)assistedQueryColumnConfig.getName(), () -> new MissingRequiredEncryptColumnException("Assisted query", new SQLExceptionIdentifier(databaseName, tableName, logicColumnName)));
        ShardingSpherePreconditions.checkNotEmpty((String)assistedQueryColumnConfig.getEncryptorName(), () -> new MissingRequiredAlgorithmException("Assist query encrypt", new SQLExceptionIdentifier(databaseName, tableName, logicColumnName)));
        ShardingSpherePreconditions.checkContainsKey(encryptors, (Object)assistedQueryColumnConfig.getEncryptorName(), () -> new UnregisteredAlgorithmException("Assist query encrypt", assistedQueryColumnConfig.getEncryptorName(), new SQLExceptionIdentifier(databaseName, tableName, logicColumnName)));
    }

    private void checkLikeColumn(String databaseName, String tableName, String logicColumnName, EncryptColumnItemRuleConfiguration likeQueryColumnConfig, Map<String, AlgorithmConfiguration> encryptors) {
        ShardingSpherePreconditions.checkNotEmpty((String)likeQueryColumnConfig.getName(), () -> new MissingRequiredEncryptColumnException("Like", new SQLExceptionIdentifier(databaseName, tableName, logicColumnName)));
        ShardingSpherePreconditions.checkNotEmpty((String)likeQueryColumnConfig.getEncryptorName(), () -> new MissingRequiredAlgorithmException("Like query", new SQLExceptionIdentifier(databaseName, tableName, logicColumnName)));
        ShardingSpherePreconditions.checkContainsKey(encryptors, (Object)likeQueryColumnConfig.getEncryptorName(), () -> new UnregisteredAlgorithmException("Like query encrypt", likeQueryColumnConfig.getEncryptorName(), new SQLExceptionIdentifier(databaseName, tableName, logicColumnName)));
    }

    public Collection<String> getTableNames(EncryptRuleConfiguration ruleConfig) {
        return ruleConfig.getTables().stream().map(EncryptTableRuleConfiguration::getName).collect(Collectors.toList());
    }

    public int getOrder() {
        return 15;
    }

    public Class<EncryptRuleConfiguration> getTypeClass() {
        return EncryptRuleConfiguration.class;
    }
}

