/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.select;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseTypeAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptIndexColumnTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext>,
DatabaseTypeAware {
    private final EncryptRule encryptRule;
    private DatabaseType databaseType;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof IndexAvailable && sqlStatementContext instanceof TableAvailable && !((TableAvailable)sqlStatementContext).getTablesContext().getTableNames().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        String tableName = (String)((TableAvailable)sqlStatementContext).getTablesContext().getTableNames().iterator().next();
        EncryptTable encryptTable = this.encryptRule.getEncryptTable(tableName);
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ColumnSegment each : ((IndexAvailable)sqlStatementContext).getIndexColumns()) {
            if (!encryptTable.isEncryptColumn(each.getIdentifier().getValue())) continue;
            this.generateSQLToken(encryptTable, each).ifPresent(result::add);
        }
        return result;
    }

    private Optional<SQLToken> generateSQLToken(EncryptTable encryptTable, ColumnSegment columnSegment) {
        QuoteCharacter quoteCharacter = columnSegment.getIdentifier().getQuoteCharacter();
        int startIndex = columnSegment.getStartIndex();
        int stopIndex = columnSegment.getStopIndex();
        String columnName = columnSegment.getIdentifier().getValue();
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(columnName);
        String queryColumnName = encryptColumn.getAssistedQuery().isPresent() ? encryptColumn.getAssistedQuery().get().getName() : encryptColumn.getCipher().getName();
        return this.getQueryColumnToken(startIndex, stopIndex, queryColumnName, quoteCharacter);
    }

    private Optional<SQLToken> getQueryColumnToken(int startIndex, int stopIndex, String queryColumnName, QuoteCharacter quoteCharacter) {
        Collection<Projection> columnProjections = this.getColumnProjections(queryColumnName, quoteCharacter);
        return Optional.of(new SubstitutableColumnNameToken(startIndex, stopIndex, columnProjections, this.databaseType));
    }

    private Collection<Projection> getColumnProjections(String columnName, QuoteCharacter quoteCharacter) {
        return Collections.singleton(new ColumnProjection(null, new IdentifierValue(columnName, quoteCharacter), null, this.databaseType));
    }

    @Generated
    public EncryptIndexColumnTokenGenerator(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

