/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.standalone.persist;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.groovy.util.Maps;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaPOJO;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;
import org.apache.shardingsphere.infra.spi.type.ordered.cache.OrderedServicesCache;
import org.apache.shardingsphere.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.metadata.persist.service.config.database.DataSourceUnitPersistService;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.event.builder.RuleConfigurationEventBuilder;
import org.apache.shardingsphere.mode.event.dispatch.DispatchEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.mode.metadata.MetaDataContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.manager.SwitchingResource;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.mode.spi.PersistRepository;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;

public final class StandaloneMetaDataManagerPersistService
implements MetaDataManagerPersistService {
    private final RuleConfigurationEventBuilder ruleConfigurationEventBuilder = new RuleConfigurationEventBuilder();
    private final MetaDataPersistService metaDataPersistService;
    private final MetaDataContextManager metaDataContextManager;

    public StandaloneMetaDataManagerPersistService(PersistRepository repository, MetaDataContextManager metaDataContextManager) {
        this.metaDataPersistService = new MetaDataPersistService(repository);
        this.metaDataContextManager = metaDataContextManager;
    }

    public void createDatabase(String databaseName) {
        this.metaDataContextManager.getSchemaMetaDataManager().addDatabase(databaseName);
        this.metaDataPersistService.getDatabaseMetaDataFacade().getDatabase().add(databaseName);
        this.clearServiceCache();
    }

    public void dropDatabase(String databaseName) {
        this.metaDataContextManager.getSchemaMetaDataManager().dropDatabase(databaseName);
        this.metaDataPersistService.getDatabaseMetaDataFacade().getDatabase().drop(databaseName);
        this.clearServiceCache();
    }

    public void createSchema(String databaseName, String schemaName) {
        ShardingSphereSchema schema = new ShardingSphereSchema(schemaName);
        ShardingSphereMetaData metaData = ((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        database.addSchema(schemaName, schema);
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
        this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().add(databaseName, schemaName);
    }

    public void alterSchema(AlterSchemaPOJO alterSchemaPOJO) {
        ShardingSphereMetaData metaData = ((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(alterSchemaPOJO.getDatabaseName());
        this.putSchemaMetaData(database, alterSchemaPOJO.getSchemaName(), alterSchemaPOJO.getRenameSchemaName(), alterSchemaPOJO.getLogicDataSourceName());
        this.removeSchemaMetaData(database, alterSchemaPOJO.getSchemaName());
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
        ShardingSphereSchema alteredSchema = database.getSchema(alterSchemaPOJO.getRenameSchemaName());
        String databaseName = alterSchemaPOJO.getDatabaseName();
        String alteredSchemaName = alterSchemaPOJO.getRenameSchemaName();
        if (alteredSchema.isEmpty()) {
            this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().add(databaseName, alteredSchemaName);
        }
        this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().persist(databaseName, alteredSchemaName, alteredSchema.getTables());
        this.metaDataPersistService.getDatabaseMetaDataFacade().getView().persist(databaseName, alteredSchemaName, alteredSchema.getViews());
        this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().drop(databaseName, alterSchemaPOJO.getSchemaName());
    }

    private void putSchemaMetaData(ShardingSphereDatabase database, String schemaName, String renameSchemaName, String logicDataSourceName) {
        ShardingSphereSchema schema = database.getSchema(schemaName);
        database.addSchema(renameSchemaName, schema);
        this.addDataNode(database, logicDataSourceName, schemaName, schema.getAllTableNames());
    }

    private void addDataNode(ShardingSphereDatabase database, String logicDataSourceName, String schemaName, Collection<String> tobeAddedTableNames) {
        tobeAddedTableNames.forEach(each -> {
            if (!Strings.isNullOrEmpty((String)logicDataSourceName) && TableRefreshUtils.isSingleTable((String)each, (ShardingSphereDatabase)database)) {
                database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class).forEach(rule -> rule.put(logicDataSourceName, schemaName, each));
            }
        });
    }

    private void addDataNode(ShardingSphereDatabase database, String logicDataSourceName, String schemaName, Map<String, ShardingSphereTable> toBeAddedTables, Map<String, ShardingSphereView> toBeAddedViews) {
        this.addTablesToDataNode(database, schemaName, logicDataSourceName, toBeAddedTables);
        this.addViewsToDataNode(database, schemaName, logicDataSourceName, toBeAddedTables, toBeAddedViews);
    }

    private void addTablesToDataNode(ShardingSphereDatabase database, String schemaName, String logicDataSourceName, Map<String, ShardingSphereTable> toBeAddedTables) {
        for (Map.Entry<String, ShardingSphereTable> entry : toBeAddedTables.entrySet()) {
            if (!Strings.isNullOrEmpty((String)logicDataSourceName) && TableRefreshUtils.isSingleTable((String)entry.getKey(), (ShardingSphereDatabase)database)) {
                database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class).forEach(rule -> rule.put(logicDataSourceName, schemaName, (String)entry.getKey()));
            }
            database.getSchema(schemaName).putTable(entry.getKey(), entry.getValue());
        }
    }

    private void addViewsToDataNode(ShardingSphereDatabase database, String schemaName, String logicDataSourceName, Map<String, ShardingSphereTable> toBeAddedTables, Map<String, ShardingSphereView> toBeAddedViews) {
        for (Map.Entry<String, ShardingSphereView> entry : toBeAddedViews.entrySet()) {
            if (!Strings.isNullOrEmpty((String)logicDataSourceName) && TableRefreshUtils.isSingleTable((String)entry.getKey(), (ShardingSphereDatabase)database)) {
                database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class).forEach(each -> each.put(logicDataSourceName, schemaName, (String)entry.getKey()));
            }
            Optional.ofNullable(toBeAddedTables.get(entry.getKey().toLowerCase())).ifPresent(optional -> database.getSchema(schemaName).putTable((String)entry.getKey(), optional));
            database.getSchema(schemaName).putView(entry.getKey(), entry.getValue());
        }
    }

    private void removeSchemaMetaData(ShardingSphereDatabase database, String schemaName) {
        ShardingSphereSchema schema = new ShardingSphereSchema(schemaName, database.getSchema(schemaName).getTables(), database.getSchema(schemaName).getViews());
        database.dropSchema(schemaName);
        this.removeDataNode((Collection<MutableDataNodeRuleAttribute>)database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class), Collections.singletonList(schemaName), (Collection<String>)schema.getAllTableNames());
    }

    private void removeDataNode(Collection<MutableDataNodeRuleAttribute> ruleAttributes, Collection<String> schemaNames, Collection<String> tobeRemovedTables) {
        tobeRemovedTables.forEach(each -> ruleAttributes.forEach(rule -> rule.remove(schemaNames, each)));
    }

    private void removeDataNode(ShardingSphereDatabase database, String schemaName, Collection<String> tobeRemovedTables, Collection<String> tobeRemovedViews) {
        this.removeTablesToDataNode(database, schemaName, tobeRemovedTables);
        this.removeViewsToDataNode(database, schemaName, tobeRemovedTables, tobeRemovedViews);
    }

    private void removeDataNode(Collection<MutableDataNodeRuleAttribute> ruleAttributes, String schemaName, Collection<String> tobeRemovedTables) {
        tobeRemovedTables.forEach(each -> ruleAttributes.forEach(rule -> rule.remove(schemaName, each)));
    }

    private void removeTablesToDataNode(ShardingSphereDatabase database, String schemaName, Collection<String> toBeDroppedTables) {
        this.removeDataNode((Collection<MutableDataNodeRuleAttribute>)database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class), schemaName, toBeDroppedTables);
        toBeDroppedTables.forEach(each -> database.getSchema(schemaName).removeTable(each));
    }

    private void removeViewsToDataNode(ShardingSphereDatabase database, String schemaName, Collection<String> toBeDroppedTables, Collection<String> toBeDroppedViews) {
        this.removeDataNode((Collection<MutableDataNodeRuleAttribute>)database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class), schemaName, toBeDroppedViews);
        ShardingSphereSchema schema = database.getSchema(schemaName);
        toBeDroppedTables.forEach(arg_0 -> ((ShardingSphereSchema)schema).removeTable(arg_0));
        toBeDroppedViews.forEach(arg_0 -> ((ShardingSphereSchema)schema).removeView(arg_0));
    }

    public void dropSchema(String databaseName, Collection<String> schemaNames) {
        LinkedList tobeRemovedTables = new LinkedList();
        LinkedList<String> tobeRemovedSchemas = new LinkedList<String>();
        ShardingSphereMetaData metaData = ((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        for (String each2 : schemaNames) {
            ShardingSphereSchema schema = new ShardingSphereSchema(each2, database.getSchema(each2).getTables(), database.getSchema(each2).getViews());
            database.dropSchema(each2);
            Optional.of(schema).ifPresent(optional -> tobeRemovedTables.addAll(optional.getAllTableNames()));
            tobeRemovedSchemas.add(each2.toLowerCase());
        }
        this.removeDataNode((Collection<MutableDataNodeRuleAttribute>)database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class), new HashSet<String>(tobeRemovedSchemas), new HashSet<String>(tobeRemovedTables));
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
    }

    public void alterSchemaMetaData(AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO) {
        String databaseName = alterSchemaMetaDataPOJO.getDatabaseName();
        String schemaName = alterSchemaMetaDataPOJO.getSchemaName();
        ShardingSphereMetaData metaData = ((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        Map<String, ShardingSphereTable> tables = alterSchemaMetaDataPOJO.getAlteredTables().stream().collect(Collectors.toMap(ShardingSphereTable::getName, table -> table));
        Map<String, ShardingSphereView> views = alterSchemaMetaDataPOJO.getAlteredViews().stream().collect(Collectors.toMap(ShardingSphereView::getName, view -> view));
        this.addDataNode(database, alterSchemaMetaDataPOJO.getLogicDataSourceName(), schemaName, tables, views);
        this.removeDataNode(database, schemaName, alterSchemaMetaDataPOJO.getDroppedTables(), alterSchemaMetaDataPOJO.getDroppedViews());
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
        this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().persist(databaseName, schemaName, tables);
        this.metaDataPersistService.getDatabaseMetaDataFacade().getView().persist(databaseName, schemaName, views);
        alterSchemaMetaDataPOJO.getDroppedTables().forEach(each -> this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().drop(databaseName, schemaName, each));
        alterSchemaMetaDataPOJO.getDroppedViews().forEach(each -> this.metaDataPersistService.getDatabaseMetaDataFacade().getView().delete(databaseName, schemaName, each));
    }

    public void registerStorageUnits(String databaseName, Map<String, DataSourcePoolProperties> toBeRegisteredProps) throws SQLException {
        SwitchingResource switchingResource = this.metaDataContextManager.getResourceSwitchManager().switchByRegisterStorageUnit(((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getDatabase(databaseName).getResourceMetaData(), toBeRegisteredProps);
        Map changedDatabases = MetaDataContextsFactory.createChangedDatabases((String)databaseName, (boolean)false, (SwitchingResource)switchingResource, null, (MetaDataContexts)((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()), (MetaDataPersistService)this.metaDataPersistService, (ComputeNodeInstanceContext)this.metaDataContextManager.getComputeNodeInstanceContext());
        ((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getDatabases().putAll(changedDatabases);
        ((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getDatabases(), GlobalRule.GlobalRuleChangedType.DATABASE_CHANGED));
        ((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getDatabase(databaseName).getSchemas().forEach((schemaName, schema) -> {
            if (schema.isEmpty()) {
                this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().add(databaseName, schemaName);
            }
            this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().persist(databaseName, schemaName, schema.getTables());
        });
        DataSourceUnitPersistService dataSourceService = this.metaDataPersistService.getDataSourceUnitService();
        this.metaDataPersistService.getMetaDataVersionPersistService().switchActiveVersion(dataSourceService.persist(databaseName, toBeRegisteredProps));
        this.clearServiceCache();
    }

    public void alterStorageUnits(String databaseName, Map<String, DataSourcePoolProperties> toBeUpdatedProps) throws SQLException {
        SwitchingResource switchingResource = this.metaDataContextManager.getResourceSwitchManager().switchByAlterStorageUnit(((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getDatabase(databaseName).getResourceMetaData(), toBeUpdatedProps);
        Map changedDatabases = MetaDataContextsFactory.createChangedDatabases((String)databaseName, (boolean)true, (SwitchingResource)switchingResource, null, (MetaDataContexts)((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()), (MetaDataPersistService)this.metaDataPersistService, (ComputeNodeInstanceContext)this.metaDataContextManager.getComputeNodeInstanceContext());
        ((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getDatabases().putAll(changedDatabases);
        ((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getDatabases(), GlobalRule.GlobalRuleChangedType.DATABASE_CHANGED));
        DataSourceUnitPersistService dataSourceService = this.metaDataPersistService.getDataSourceUnitService();
        this.metaDataPersistService.getMetaDataVersionPersistService().switchActiveVersion(dataSourceService.persist(databaseName, toBeUpdatedProps));
        switchingResource.closeStaleDataSources();
        this.clearServiceCache();
    }

    public void unregisterStorageUnits(String databaseName, Collection<String> toBeDroppedStorageUnitNames) throws SQLException {
        SwitchingResource switchingResource = this.metaDataContextManager.getResourceSwitchManager().switchByUnregisterStorageUnit(((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getDatabase(databaseName).getResourceMetaData(), toBeDroppedStorageUnitNames);
        MetaDataContexts reloadMetaDataContexts = MetaDataContextsFactory.createBySwitchResource((String)databaseName, (boolean)false, (SwitchingResource)switchingResource, (MetaDataContexts)((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()), (MetaDataPersistService)this.metaDataPersistService, (ComputeNodeInstanceContext)this.metaDataContextManager.getComputeNodeInstanceContext());
        this.metaDataPersistService.persistReloadDatabaseByDrop(databaseName, reloadMetaDataContexts.getMetaData().getDatabase(databaseName), ((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getDatabase(databaseName));
        this.metaDataContextManager.dropSchemas(databaseName, reloadMetaDataContexts.getMetaData().getDatabase(databaseName), ((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getDatabase(databaseName));
        this.metaDataContextManager.renewMetaDataContexts(reloadMetaDataContexts);
        switchingResource.closeStaleDataSources();
        this.clearServiceCache();
    }

    public void alterSingleRuleConfiguration(String databaseName, Collection<RuleConfiguration> ruleConfigs) throws SQLException {
        ruleConfigs.removeIf(each -> !each.getClass().isAssignableFrom(SingleRuleConfiguration.class));
        Collection metaDataVersions = this.metaDataPersistService.getDatabaseRulePersistService().persist(((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getDatabase(databaseName).getName(), ruleConfigs);
        this.metaDataPersistService.getMetaDataVersionPersistService().switchActiveVersion(metaDataVersions);
        this.metaDataContextManager.getDatabaseRuleConfigurationManager().alterRuleConfiguration(databaseName, ruleConfigs.iterator().next());
        this.clearServiceCache();
    }

    public void alterRuleConfiguration(String databaseName, RuleConfiguration toBeAlteredRuleConfig) throws SQLException {
        if (null == toBeAlteredRuleConfig) {
            return;
        }
        Collection metaDataVersions = this.metaDataPersistService.getDatabaseRulePersistService().persist(((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData().getDatabase(databaseName).getName(), Collections.singleton(toBeAlteredRuleConfig));
        this.metaDataPersistService.getMetaDataVersionPersistService().switchActiveVersion(metaDataVersions);
        for (MetaDataVersion each : metaDataVersions) {
            Optional<DispatchEvent> ruleItemEvent = this.buildAlterRuleItemEvent(databaseName, each, DataChangedEvent.Type.UPDATED);
            if (!ruleItemEvent.isPresent() || !(ruleItemEvent.get() instanceof AlterRuleItemEvent)) continue;
            this.metaDataContextManager.getRuleItemManager().alterRuleItem((AlterRuleItemEvent)ruleItemEvent.get());
        }
        this.clearServiceCache();
    }

    private Optional<DispatchEvent> buildAlterRuleItemEvent(String databaseName, MetaDataVersion metaDataVersion, DataChangedEvent.Type type) {
        return this.ruleConfigurationEventBuilder.build(databaseName, new DataChangedEvent(metaDataVersion.getActiveVersionNodePath(), metaDataVersion.getNextActiveVersion(), type));
    }

    public void removeRuleConfigurationItem(String databaseName, RuleConfiguration toBeRemovedRuleConfig) throws SQLException {
        if (null == toBeRemovedRuleConfig) {
            return;
        }
        Collection metaDataVersions = this.metaDataPersistService.getDatabaseRulePersistService().delete(databaseName, Collections.singleton(toBeRemovedRuleConfig));
        for (MetaDataVersion metaDataVersion : metaDataVersions) {
            Optional<DispatchEvent> ruleItemEvent = this.buildAlterRuleItemEvent(databaseName, metaDataVersion, DataChangedEvent.Type.DELETED);
            if (!ruleItemEvent.isPresent() || !(ruleItemEvent.get() instanceof DropRuleItemEvent)) continue;
            this.metaDataContextManager.getRuleItemManager().dropRuleItem((DropRuleItemEvent)ruleItemEvent.get());
        }
        this.clearServiceCache();
    }

    public void removeRuleConfiguration(String databaseName, String ruleName) {
        this.metaDataPersistService.getDatabaseRulePersistService().delete(databaseName, ruleName);
        this.clearServiceCache();
    }

    public void alterGlobalRuleConfiguration(RuleConfiguration toBeAlteredRuleConfig) {
        this.metaDataContextManager.getGlobalConfigurationManager().alterGlobalRuleConfiguration(toBeAlteredRuleConfig);
        this.metaDataPersistService.getGlobalRuleService().persist(Collections.singleton(toBeAlteredRuleConfig));
        this.clearServiceCache();
    }

    public void alterProperties(Properties props) {
        this.metaDataContextManager.getGlobalConfigurationManager().alterProperties(props);
        this.metaDataPersistService.getPropsService().persist(props);
        this.clearServiceCache();
    }

    public void createTable(String databaseName, String schemaName, ShardingSphereTable table, String logicDataSourceName) {
        ShardingSphereMetaData metaData = ((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        this.addTableToDataNode(database, schemaName, logicDataSourceName, table);
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
        this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().persist(databaseName, schemaName, Maps.of((Object)table.getName(), (Object)table));
    }

    public void dropTables(String databaseName, String schemaName, Collection<String> tableNames) {
        ShardingSphereMetaData metaData = ((MetaDataContexts)this.metaDataContextManager.getMetaDataContexts().get()).getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        this.removeTablesToDataNode(database, schemaName, tableNames);
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
        tableNames.forEach(each -> this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().drop(databaseName, schemaName, each));
    }

    private void addTableToDataNode(ShardingSphereDatabase database, String schemaName, String logicDataSourceName, ShardingSphereTable table) {
        if (!Strings.isNullOrEmpty((String)logicDataSourceName) && TableRefreshUtils.isSingleTable((String)table.getName(), (ShardingSphereDatabase)database)) {
            database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class).forEach(rule -> rule.put(logicDataSourceName, schemaName, table.getName()));
        }
        database.getSchema(schemaName).putTable(table.getName(), table);
    }

    private void clearServiceCache() {
        OrderedServicesCache.clearCache();
    }
}

