/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.yaml.swapper;

import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.YamlShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.datasource.YamlShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.table.YamlShadowTableConfiguration;
import org.apache.shardingsphere.shadow.yaml.swapper.table.YamlShadowTableConfigurationSwapper;

public final class YamlShadowRuleConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlShadowRuleConfiguration, ShadowRuleConfiguration> {
    private final YamlShadowTableConfigurationSwapper tableConfigurationSwapper = new YamlShadowTableConfigurationSwapper();
    private final YamlAlgorithmConfigurationSwapper algorithmSwapper = new YamlAlgorithmConfigurationSwapper();

    public YamlShadowRuleConfiguration swapToYamlConfiguration(ShadowRuleConfiguration data) {
        YamlShadowRuleConfiguration result = new YamlShadowRuleConfiguration();
        result.setDefaultShadowAlgorithmName(data.getDefaultShadowAlgorithmName());
        this.setTableDefaultShadowDataSource(data.getTables(), data.getDataSources());
        this.setTableDefaultShadowAlgorithm(data.getTables(), data.getDefaultShadowAlgorithmName());
        this.parseDataSources(data, result);
        this.parseShadowTables(data, result);
        this.parseShadowAlgorithms(data, result);
        return result;
    }

    private void parseDataSources(ShadowRuleConfiguration data, YamlShadowRuleConfiguration yamlConfig) {
        data.getDataSources().forEach(each -> yamlConfig.getDataSources().put(each.getName(), this.swapToDataSourceYamlConfiguration((ShadowDataSourceConfiguration)each)));
    }

    private YamlShadowDataSourceConfiguration swapToDataSourceYamlConfiguration(ShadowDataSourceConfiguration data) {
        YamlShadowDataSourceConfiguration result = new YamlShadowDataSourceConfiguration();
        result.setProductionDataSourceName(data.getProductionDataSourceName());
        result.setShadowDataSourceName(data.getShadowDataSourceName());
        return result;
    }

    private void parseShadowTables(ShadowRuleConfiguration data, YamlShadowRuleConfiguration yamlConfig) {
        data.getTables().forEach((key, value) -> yamlConfig.getTables().put((String)key, this.tableConfigurationSwapper.swapToYamlConfiguration((ShadowTableConfiguration)value)));
    }

    private void parseShadowAlgorithms(ShadowRuleConfiguration data, YamlShadowRuleConfiguration yamlConfig) {
        data.getShadowAlgorithms().forEach((key, value) -> yamlConfig.getShadowAlgorithms().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
    }

    public ShadowRuleConfiguration swapToObject(YamlShadowRuleConfiguration yamlConfig) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        result.setDefaultShadowAlgorithmName(yamlConfig.getDefaultShadowAlgorithmName());
        this.parseYamlDataSources(yamlConfig, result);
        this.parseYamlShadowTables(yamlConfig, result);
        this.parseYamlShadowAlgorithms(yamlConfig, result);
        this.setTableDefaultShadowDataSource(result.getTables(), result.getDataSources());
        this.setTableDefaultShadowAlgorithm(result.getTables(), result.getDefaultShadowAlgorithmName());
        return result;
    }

    private void parseYamlShadowAlgorithms(YamlShadowRuleConfiguration yamlConfig, ShadowRuleConfiguration data) {
        yamlConfig.getShadowAlgorithms().forEach((key, value) -> data.getShadowAlgorithms().put(key, this.algorithmSwapper.swapToObject(value)));
    }

    private void parseYamlShadowTables(YamlShadowRuleConfiguration yamlConfig, ShadowRuleConfiguration data) {
        yamlConfig.getTables().forEach((key, value) -> data.getTables().put(key, this.tableConfigurationSwapper.swapToObject((YamlShadowTableConfiguration)value)));
    }

    private void parseYamlDataSources(YamlShadowRuleConfiguration yamlConfig, ShadowRuleConfiguration data) {
        yamlConfig.getDataSources().forEach((key, value) -> data.getDataSources().add(this.swapToDataSourceObject((String)key, (YamlShadowDataSourceConfiguration)value)));
    }

    private ShadowDataSourceConfiguration swapToDataSourceObject(String name, YamlShadowDataSourceConfiguration yamlConfig) {
        return new ShadowDataSourceConfiguration(name, yamlConfig.getProductionDataSourceName(), yamlConfig.getShadowDataSourceName());
    }

    private void setTableDefaultShadowDataSource(Map<String, ShadowTableConfiguration> shadowTables, Collection<ShadowDataSourceConfiguration> shadowDataSources) {
        if (1 == shadowDataSources.size()) {
            for (ShadowTableConfiguration each : shadowTables.values()) {
                if (!each.getDataSourceNames().isEmpty()) continue;
                each.getDataSourceNames().add(shadowDataSources.iterator().next().getName());
            }
        }
    }

    private void setTableDefaultShadowAlgorithm(Map<String, ShadowTableConfiguration> shadowTables, String defaultShadowAlgorithmName) {
        for (ShadowTableConfiguration each : shadowTables.values()) {
            Collection shadowAlgorithmNames = each.getShadowAlgorithmNames();
            if (null == defaultShadowAlgorithmName || !shadowAlgorithmNames.isEmpty()) continue;
            shadowAlgorithmNames.add(defaultShadowAlgorithmName);
        }
    }

    public Class<ShadowRuleConfiguration> getTypeClass() {
        return ShadowRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "SHADOW";
    }

    public int getOrder() {
        return 55;
    }
}

