/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.atomikos.manager;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.icatch.config.UserTransactionService;
import com.atomikos.icatch.config.UserTransactionServiceImp;
import com.atomikos.icatch.jta.UserTransactionManager;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import lombok.Generated;
import org.apache.shardingsphere.transaction.xa.atomikos.manager.AtomikosXARecoverableResource;
import org.apache.shardingsphere.transaction.xa.spi.SingleXAResource;
import org.apache.shardingsphere.transaction.xa.spi.XATransactionManagerProvider;

public final class AtomikosTransactionManagerProvider
implements XATransactionManagerProvider {
    private UserTransactionManager transactionManager;
    private UserTransactionService userTransactionService;

    public void init() {
        this.transactionManager = new UserTransactionManager();
        this.userTransactionService = new UserTransactionServiceImp();
        this.userTransactionService.init();
    }

    public void registerRecoveryResource(String dataSourceName, XADataSource xaDataSource) {
        this.userTransactionService.registerResource((RecoverableResource)new AtomikosXARecoverableResource(dataSourceName, xaDataSource));
    }

    public void removeRecoveryResource(String dataSourceName, XADataSource xaDataSource) {
        this.userTransactionService.removeResource((RecoverableResource)new AtomikosXARecoverableResource(dataSourceName, xaDataSource));
    }

    public void enlistResource(SingleXAResource xaResource) {
        this.transactionManager.getTransaction().enlistResource((XAResource)xaResource);
    }

    public void close() {
        this.userTransactionService.shutdown(true);
    }

    public String getType() {
        return "Atomikos";
    }

    public boolean isDefault() {
        return true;
    }

    @Generated
    public UserTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

