/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.distsql.handler.migration.update;

import java.sql.SQLException;
import java.util.Properties;
import org.apache.shardingsphere.data.pipeline.core.exception.param.PipelineInvalidParameterException;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.PipelineJobProgressDetector;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobConfigurationManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.TransmissionJobManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.migration.distsql.statement.updatable.CheckMigrationStatement;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobType;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.api.ConsistencyCheckJobAPI;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.api.CreateConsistencyCheckJobParameter;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobType;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationJobConfiguration;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class CheckMigrationJobExecutor
implements DistSQLUpdateExecutor<CheckMigrationStatement> {
    private final ConsistencyCheckJobAPI checkJobAPI = new ConsistencyCheckJobAPI(new ConsistencyCheckJobType());
    private final PipelineJobType migrationJobType = new MigrationJobType();

    public void executeUpdate(CheckMigrationStatement sqlStatement, ContextManager contextManager) throws SQLException {
        AlgorithmSegment typeStrategy = sqlStatement.getTypeStrategy();
        String algorithmTypeName = null == typeStrategy ? null : typeStrategy.getName();
        Properties algorithmProps = null == typeStrategy ? null : typeStrategy.getProps();
        String jobId = sqlStatement.getJobId();
        MigrationJobConfiguration jobConfig = (MigrationJobConfiguration)new PipelineJobConfigurationManager(this.migrationJobType).getJobConfiguration(jobId);
        this.verifyInventoryFinished(jobConfig);
        this.checkJobAPI.start(new CreateConsistencyCheckJobParameter(jobId, algorithmTypeName, algorithmProps, jobConfig.getSourceDatabaseType(), jobConfig.getTargetDatabaseType()));
    }

    private void verifyInventoryFinished(MigrationJobConfiguration jobConfig) {
        TransmissionJobManager transmissionJobManager = new TransmissionJobManager(this.migrationJobType);
        ShardingSpherePreconditions.checkState((boolean)PipelineJobProgressDetector.isInventoryFinished((int)jobConfig.getJobShardingCount(), transmissionJobManager.getJobProgress((PipelineJobConfiguration)jobConfig).values()), () -> new PipelineInvalidParameterException("Inventory is not finished."));
    }

    public Class<CheckMigrationStatement> getType() {
        return CheckMigrationStatement.class;
    }
}

