/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.PostgreSQLDDLTemplateExecutor;

public final class PostgreSQLTablePropertiesLoader {
    private final String tableName;
    private final String schemaName;
    private final PostgreSQLDDLTemplateExecutor templateExecutor;

    public PostgreSQLTablePropertiesLoader(Connection connection, String tableName, String schemaName, int majorVersion, int minorVersion) {
        this.tableName = tableName;
        this.schemaName = schemaName;
        this.templateExecutor = new PostgreSQLDDLTemplateExecutor(connection, majorVersion, minorVersion);
    }

    public Map<String, Object> load() throws SQLException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.fetchDataBaseId(result);
        this.fetchSchemaId(result);
        this.fetchTableId(result);
        this.fetchTableProperties(result);
        return result;
    }

    private void fetchDataBaseId(Map<String, Object> context) throws SQLException {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("databaseName", this.templateExecutor.getConnection().getCatalog());
        context.putAll(this.templateExecutor.executeByTemplateForSingleRow(params, "component/table/%s/get_database_id.ftl"));
    }

    private void fetchTableId(Map<String, Object> context) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("schemaName", this.schemaName);
        params.put("tableName", this.tableName);
        context.putAll(this.templateExecutor.executeByTemplateForSingleRow(params, "component/table/%s/get_table_id.ftl"));
    }

    private void fetchSchemaId(Map<String, Object> context) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("schemaName", this.schemaName);
        context.putAll(this.templateExecutor.executeByTemplateForSingleRow(params, "component/table/%s/get_schema_id.ftl"));
    }

    private void fetchTableProperties(Map<String, Object> context) throws SQLException {
        context.putAll(this.templateExecutor.executeByTemplateForSingleRow(context, "component/table/%s/properties.ftl"));
        this.updateAutovacuumProperties(context);
        this.checkRlspolicySupport(context);
        this.templateExecutor.formatSecurityLabels(context);
    }

    private void updateAutovacuumProperties(Map<String, Object> context) {
        if (null == context.get("autovacuum_enabled")) {
            context.put("autovacuum_enabled", "x");
        } else if (Boolean.TRUE.toString().equalsIgnoreCase(context.get("autovacuum_enabled").toString())) {
            context.put("autovacuum_enabled", "t");
        } else {
            context.put("autovacuum_enabled", "f");
        }
        if (null == context.get("toast_autovacuum_enabled")) {
            context.put("toast_autovacuum_enabled", "x");
        } else if (Boolean.TRUE.toString().equalsIgnoreCase(context.get("toast_autovacuum_enabled").toString())) {
            context.put("toast_autovacuum_enabled", "t");
        } else {
            context.put("toast_autovacuum_enabled", "f");
        }
        context.put("autovacuum_custom", this.anyIsTrue(Arrays.asList(context.get("autovacuum_vacuum_threshold"), context.get("autovacuum_vacuum_scale_factor"), context.get("autovacuum_analyze_threshold"), context.get("autovacuum_analyze_scale_factor"), context.get("autovacuum_vacuum_cost_delay"), context.get("autovacuum_vacuum_cost_limit"), context.get("autovacuum_freeze_min_age"), context.get("autovacuum_freeze_max_age"), context.get("autovacuum_freeze_table_age"))) || "t".equals(context.get("autovacuum_enabled")) || "f".equals(context.get("autovacuum_enabled")));
        context.put("toast_autovacuum", this.anyIsTrue(Arrays.asList(context.get("toast_autovacuum_vacuum_threshold"), context.get("toast_autovacuum_vacuum_scale_factor"), context.get("toast_autovacuum_analyze_threshold"), context.get("toast_autovacuum_analyze_scale_factor"), context.get("toast_autovacuum_vacuum_cost_delay"), context.get("toast_autovacuum_vacuum_cost_limit"), context.get("toast_autovacuum_freeze_min_age"), context.get("toast_autovacuum_freeze_max_age"), context.get("toast_autovacuum_freeze_table_age"))) || "t".equals(context.get("toast_autovacuum_enabled")) || "f".equals(context.get("toast_autovacuum_enabled")));
    }

    private void checkRlspolicySupport(Map<String, Object> context) {
        if (context.containsKey("rlspolicy")) {
            if (context.get("rlspolicy") instanceof String && Boolean.TRUE.toString().equals(context.get("rlspolicy"))) {
                context.put("rlspolicy", true);
            }
            if (context.get("forcerlspolicy") instanceof String && Boolean.TRUE.toString().equals(context.get("forcerlspolicy"))) {
                context.put("forcerlspolicy", true);
            }
        }
    }

    private boolean anyIsTrue(Collection<Object> collection) {
        for (Object each : collection) {
            if (!(each instanceof Boolean) || !((Boolean)each).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

