/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryCell;
import org.apache.shardingsphere.db.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLValueFormat;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLColumnDescription;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLDataRowPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLEmptyQueryResponsePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLNoDataPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLRowDescriptionPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.util.PostgreSQLTextBitUtils;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.util.PostgreSQLTextBoolUtils;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.execute.PostgreSQLPortalSuspendedPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLCommandCompletePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLParameterStatusPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.infra.binder.context.aware.ParameterAware;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.PostgreSQLCommand;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.PostgreSQLServerPreparedStatement;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.EmptyStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class Portal {
    private final String name;
    private final SQLStatement sqlStatement;
    private final List<PostgreSQLValueFormat> resultFormats;
    private final ProxyBackendHandler proxyBackendHandler;
    private final ProxyDatabaseConnectionManager databaseConnectionManager;
    private ResponseHeader responseHeader;

    public Portal(String name, PostgreSQLServerPreparedStatement preparedStatement, List<Object> params, List<PostgreSQLValueFormat> resultFormats, ProxyDatabaseConnectionManager databaseConnectionManager) throws SQLException {
        this.name = name;
        this.sqlStatement = preparedStatement.getSqlStatementContext().getSqlStatement();
        this.resultFormats = resultFormats;
        this.databaseConnectionManager = databaseConnectionManager;
        String databaseName = databaseConnectionManager.getConnectionSession().getCurrentDatabaseName();
        SQLStatementContext sqlStatementContext = preparedStatement.getSqlStatementContext();
        if (sqlStatementContext instanceof ParameterAware) {
            ((ParameterAware)sqlStatementContext).setUpParameters(params);
        }
        DatabaseType protocolType = ProxyContext.getInstance().getContextManager().getDatabase(databaseName).getProtocolType();
        QueryContext queryContext = new QueryContext(sqlStatementContext, preparedStatement.getSql(), params, preparedStatement.getHintValueContext(), databaseConnectionManager.getConnectionSession().getConnectionContext(), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(), true);
        databaseConnectionManager.getConnectionSession().setQueryContext(queryContext);
        this.proxyBackendHandler = ProxyBackendHandlerFactory.newInstance((DatabaseType)protocolType, (QueryContext)queryContext, (ConnectionSession)databaseConnectionManager.getConnectionSession(), (boolean)true);
    }

    public void bind() throws SQLException {
        this.responseHeader = this.proxyBackendHandler.execute();
    }

    public PostgreSQLPacket describe() {
        if (this.responseHeader instanceof QueryResponseHeader) {
            return this.createRowDescriptionPacket((QueryResponseHeader)this.responseHeader);
        }
        if (this.responseHeader instanceof UpdateResponseHeader) {
            return PostgreSQLNoDataPacket.getInstance();
        }
        throw new IllegalStateException(String.format("Can not describe portal `%s` before bind", this.name));
    }

    private PostgreSQLRowDescriptionPacket createRowDescriptionPacket(QueryResponseHeader queryResponseHeader) {
        return new PostgreSQLRowDescriptionPacket(this.createColumnDescriptions(queryResponseHeader));
    }

    private Collection<PostgreSQLColumnDescription> createColumnDescriptions(QueryResponseHeader queryResponseHeader) {
        LinkedList<PostgreSQLColumnDescription> result = new LinkedList<PostgreSQLColumnDescription>();
        int columnIndex = 0;
        for (QueryHeader each : queryResponseHeader.getQueryHeaders()) {
            PostgreSQLValueFormat valueFormat = this.determineValueFormat(columnIndex);
            result.add(new PostgreSQLColumnDescription(each.getColumnLabel(), ++columnIndex, each.getColumnType(), each.getColumnLength(), each.getColumnTypeName(), valueFormat.getCode()));
        }
        return result;
    }

    public List<DatabasePacket> execute(int maxRows) throws SQLException {
        int fetchSize = maxRows > 0 ? maxRows : Integer.MAX_VALUE;
        LinkedList<DatabasePacket> result = new LinkedList<DatabasePacket>();
        for (int i = 0; i < fetchSize && this.hasNext(); ++i) {
            result.add((DatabasePacket)this.nextPacket());
        }
        if (this.responseHeader instanceof UpdateResponseHeader && this.sqlStatement instanceof SetStatement) {
            result.addAll(this.createParameterStatusResponse((SetStatement)this.sqlStatement));
            return result;
        }
        result.add((DatabasePacket)this.createExecutionCompletedPacket(maxRows > 0 && maxRows == result.size(), result.size()));
        return result;
    }

    private List<PostgreSQLPacket> createParameterStatusResponse(SetStatement sqlStatement) {
        ArrayList<PostgreSQLPacket> result = new ArrayList<PostgreSQLPacket>(2);
        result.add((PostgreSQLPacket)new PostgreSQLCommandCompletePacket("SET", 0L));
        for (VariableAssignSegment each : sqlStatement.getVariableAssigns()) {
            result.add((PostgreSQLPacket)new PostgreSQLParameterStatusPacket(each.getVariable().getVariable(), IdentifierValue.getQuotedContent((String)each.getAssignValue())));
        }
        return result;
    }

    private boolean hasNext() throws SQLException {
        return this.proxyBackendHandler.next();
    }

    private PostgreSQLPacket nextPacket() throws SQLException {
        return new PostgreSQLDataRowPacket(this.getData(this.proxyBackendHandler.getRowData()));
    }

    private List<Object> getData(QueryResponseRow queryResponseRow) {
        List cells = queryResponseRow.getCells();
        ArrayList<Object> result = new ArrayList<Object>(cells.size());
        ArrayList columns = new ArrayList(cells);
        for (int i = 0; i < columns.size(); ++i) {
            PostgreSQLValueFormat format = this.determineValueFormat(i);
            result.add(PostgreSQLValueFormat.BINARY == format ? this.createBinaryCell((QueryResponseCell)columns.get(i)) : this.getCellData((QueryResponseCell)columns.get(i)));
        }
        return result;
    }

    private PostgreSQLValueFormat determineValueFormat(int columnIndex) {
        return this.resultFormats.isEmpty() ? PostgreSQLValueFormat.TEXT : this.resultFormats.get(columnIndex % this.resultFormats.size());
    }

    private BinaryCell createBinaryCell(QueryResponseCell cell) {
        return new BinaryCell((BinaryColumnType)PostgreSQLColumnType.valueOfJDBCType((int)cell.getJdbcType(), (String)cell.getColumnTypeName().orElse(null)), this.getCellData(cell));
    }

    private Object getCellData(QueryResponseCell cell) {
        if (PostgreSQLColumnType.isBit((int)cell.getJdbcType(), (String)cell.getColumnTypeName().orElse(null))) {
            return PostgreSQLTextBitUtils.getTextValue((Object)cell.getData());
        }
        if (PostgreSQLColumnType.isBool((int)cell.getJdbcType(), (String)cell.getColumnTypeName().orElse(null))) {
            return PostgreSQLTextBoolUtils.getTextValue((Object)cell.getData());
        }
        return cell.getData();
    }

    private PostgreSQLIdentifierPacket createExecutionCompletedPacket(boolean isSuspended, int fetchedRows) {
        if (isSuspended) {
            this.suspendPortal();
            return new PostgreSQLPortalSuspendedPacket();
        }
        if (this.getSqlStatement() instanceof EmptyStatement) {
            return new PostgreSQLEmptyQueryResponsePacket();
        }
        String sqlCommand = PostgreSQLCommand.valueOf(this.getSqlStatement().getClass()).map(PostgreSQLCommand::getTag).orElse("");
        return new PostgreSQLCommandCompletePacket(sqlCommand, Math.max((long)fetchedRows, this.getUpdateCount()));
    }

    private void suspendPortal() {
        this.databaseConnectionManager.markResourceInUse(this.proxyBackendHandler);
    }

    private long getUpdateCount() {
        return this.responseHeader instanceof UpdateResponseHeader ? ((UpdateResponseHeader)this.responseHeader).getUpdateCount() : 0L;
    }

    public void close() throws SQLException {
        this.databaseConnectionManager.unmarkResourceInUse(this.proxyBackendHandler);
        this.proxyBackendHandler.close();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public SQLStatement getSqlStatement() {
        return this.sqlStatement;
    }
}

