/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.simple;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLColumnDescription;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLDataRowPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLEmptyQueryResponsePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLRowDescriptionPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.simple.PostgreSQLComQueryPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLCommandCompletePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLParameterStatusPacket;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.ProxySQLComQueryParser;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PortalContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.PostgreSQLCommand;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.EmptyStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.RollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class PostgreSQLComQueryExecutor
implements QueryCommandExecutor {
    private final PortalContext portalContext;
    private final ProxyBackendHandler proxyBackendHandler;
    private volatile ResponseType responseType;

    public PostgreSQLComQueryExecutor(PortalContext portalContext, PostgreSQLComQueryPacket packet, ConnectionSession connectionSession) throws SQLException {
        this.portalContext = portalContext;
        DatabaseType databaseType = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"PostgreSQL");
        SQLStatement sqlStatement = ProxySQLComQueryParser.parse((String)packet.getSQL(), (DatabaseType)databaseType, (ConnectionSession)connectionSession);
        this.proxyBackendHandler = ProxyBackendHandlerFactory.newInstance((DatabaseType)databaseType, (String)packet.getSQL(), (SQLStatement)sqlStatement, (ConnectionSession)connectionSession, (HintValueContext)packet.getHintValueContext());
    }

    public Collection<DatabasePacket> execute() throws SQLException {
        ResponseHeader responseHeader = this.proxyBackendHandler.execute();
        if (responseHeader instanceof QueryResponseHeader) {
            return Collections.singleton(this.createRowDescriptionPacket((QueryResponseHeader)responseHeader));
        }
        this.responseType = ResponseType.UPDATE;
        return this.createUpdatePacket((UpdateResponseHeader)responseHeader);
    }

    private PostgreSQLRowDescriptionPacket createRowDescriptionPacket(QueryResponseHeader queryResponseHeader) {
        this.responseType = ResponseType.QUERY;
        return new PostgreSQLRowDescriptionPacket(this.createColumnDescriptions(queryResponseHeader));
    }

    private Collection<PostgreSQLColumnDescription> createColumnDescriptions(QueryResponseHeader queryResponseHeader) {
        LinkedList<PostgreSQLColumnDescription> result = new LinkedList<PostgreSQLColumnDescription>();
        int columnIndex = 0;
        for (QueryHeader each : queryResponseHeader.getQueryHeaders()) {
            result.add(new PostgreSQLColumnDescription(each.getColumnLabel(), ++columnIndex, each.getColumnType(), each.getColumnLength(), each.getColumnTypeName()));
        }
        return result;
    }

    private Collection<DatabasePacket> createUpdatePacket(UpdateResponseHeader updateResponseHeader) throws SQLException {
        SQLStatement sqlStatement = updateResponseHeader.getSqlStatement();
        if (sqlStatement instanceof CommitStatement || sqlStatement instanceof RollbackStatement) {
            this.portalContext.closeAll();
        }
        if (sqlStatement instanceof SetStatement) {
            return this.createParameterStatusResponse((SetStatement)sqlStatement);
        }
        return Collections.singletonList(sqlStatement instanceof EmptyStatement ? new PostgreSQLEmptyQueryResponsePacket() : new PostgreSQLCommandCompletePacket(PostgreSQLCommand.valueOf(sqlStatement.getClass()).map(PostgreSQLCommand::getTag).orElse(""), updateResponseHeader.getUpdateCount()));
    }

    private Collection<DatabasePacket> createParameterStatusResponse(SetStatement sqlStatement) {
        ArrayList<DatabasePacket> result = new ArrayList<DatabasePacket>(2);
        result.add((DatabasePacket)new PostgreSQLCommandCompletePacket("SET", 0L));
        for (VariableAssignSegment each : sqlStatement.getVariableAssigns()) {
            result.add((DatabasePacket)new PostgreSQLParameterStatusPacket(each.getVariable().getVariable(), IdentifierValue.getQuotedContent((String)each.getAssignValue())));
        }
        return result;
    }

    public boolean next() throws SQLException {
        return this.proxyBackendHandler.next();
    }

    public PostgreSQLPacket getQueryRowPacket() throws SQLException {
        return new PostgreSQLDataRowPacket((Collection)this.proxyBackendHandler.getRowData().getData());
    }

    public void close() throws SQLException {
        this.proxyBackendHandler.close();
    }

    @Generated
    public ResponseType getResponseType() {
        return this.responseType;
    }
}

