/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.rule.attribute;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;

public final class BroadcastDataNodeRuleAttribute
implements DataNodeRuleAttribute {
    private final Collection<String> tables;
    private final Map<String, Collection<DataNode>> tableDataNodes;

    public BroadcastDataNodeRuleAttribute(Collection<String> dataSourceNames, Collection<String> tables) {
        this.tables = tables;
        this.tableDataNodes = tables.stream().collect(Collectors.toMap(String::toLowerCase, each -> this.generateDataNodes((String)each, dataSourceNames)));
    }

    private Collection<DataNode> generateDataNodes(String logicTable, Collection<String> dataSourceNames) {
        return dataSourceNames.stream().map(each -> new DataNode(each, logicTable)).collect(Collectors.toList());
    }

    public Map<String, Collection<DataNode>> getAllDataNodes() {
        return this.tableDataNodes;
    }

    public Collection<DataNode> getDataNodesByTableName(String tableName) {
        return this.tableDataNodes.getOrDefault(tableName, Collections.emptyList());
    }

    public Optional<String> findFirstActualTable(String logicTable) {
        return this.tableDataNodes.containsKey(logicTable.toLowerCase()) ? Optional.of(logicTable) : Optional.empty();
    }

    public boolean isNeedAccumulate(Collection<String> tables) {
        return tables.isEmpty() || !this.tables.containsAll(tables);
    }

    public Optional<String> findLogicTableByActualTable(String actualTable) {
        return this.tableDataNodes.containsKey(actualTable.toLowerCase()) ? Optional.of(actualTable) : Optional.empty();
    }

    public Optional<String> findActualTableByCatalog(String catalog, String logicTable) {
        if (!this.tableDataNodes.containsKey(logicTable.toLowerCase())) {
            return Optional.empty();
        }
        if (this.tableDataNodes.get(logicTable.toLowerCase()).stream().noneMatch(each -> each.getDataSourceName().equalsIgnoreCase(catalog))) {
            return Optional.empty();
        }
        return Optional.of(logicTable);
    }
}

