/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.engine;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.context.AlgorithmSQLContext;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.data.InsertColumnsAndValuesMismatchedException;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.table.NoSuchTableException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.route.engine.condition.ExpressionConditionUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.WhereClauseShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.timeservice.core.rule.TimestampServiceRule;

public final class InsertClauseShardingConditionEngine {
    private final ShardingSphereDatabase database;
    private final ShardingRule shardingRule;
    private final TimestampServiceRule timestampServiceRule;

    public List<ShardingCondition> createShardingConditions(InsertStatementContext sqlStatementContext, List<Object> params) {
        List<ShardingCondition> result = null == sqlStatementContext.getInsertSelectContext() ? this.createShardingConditionsWithInsertValues(sqlStatementContext, params) : this.createShardingConditionsWithInsertSelect(sqlStatementContext, params);
        this.appendGeneratedKeyConditions(sqlStatementContext, result);
        return result;
    }

    private List<ShardingCondition> createShardingConditionsWithInsertValues(InsertStatementContext sqlStatementContext, List<Object> params) {
        String tableName = sqlStatementContext.getSqlStatement().getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElseGet(() -> (String)sqlStatementContext.getTablesContext().getTableNames().iterator().next());
        Collection<String> columnNames = this.getColumnNames(sqlStatementContext);
        List insertValueContexts = sqlStatementContext.getInsertValueContexts();
        ArrayList<ShardingCondition> result = new ArrayList<ShardingCondition>(insertValueContexts.size());
        int rowNumber = 0;
        for (InsertValueContext each : insertValueContexts) {
            result.add(this.createShardingCondition(tableName, columnNames.iterator(), each, params, ++rowNumber));
        }
        this.appendMissingShardingConditions(sqlStatementContext, columnNames, result);
        return result;
    }

    private void appendMissingShardingConditions(InsertStatementContext sqlStatementContext, Collection<String> columnNames, List<ShardingCondition> shardingConditions) {
        String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(this.database.getName());
        ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)this.database).getSchema(arg_0)).orElseGet(() -> this.database.getSchema(defaultSchemaName));
        String tableName = sqlStatementContext.getSqlStatement().getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElseGet(() -> (String)sqlStatementContext.getTablesContext().getTableNames().iterator().next());
        ShardingSpherePreconditions.checkState((boolean)schema.containsTable(tableName), () -> new NoSuchTableException(tableName));
        List allColumnNames = schema.getTable(tableName).getColumnNames();
        if (columnNames.size() == allColumnNames.size()) {
            return;
        }
        for (String each : allColumnNames) {
            if (columnNames.contains(each.toLowerCase()) || this.shardingRule.isGenerateKeyColumn(each, tableName) || !this.shardingRule.findShardingColumn(each, tableName).isPresent()) continue;
            this.appendMissingShardingConditions(shardingConditions, each, tableName);
        }
    }

    private void appendMissingShardingConditions(List<ShardingCondition> shardingConditions, String columnName, String tableName) {
        for (ShardingCondition each : shardingConditions) {
            each.getValues().add(new ListShardingConditionValue<Object>(columnName, tableName, Collections.singletonList(null)));
        }
    }

    private Collection<String> getColumnNames(InsertStatementContext insertStatementContext) {
        Optional generatedKey = insertStatementContext.getGeneratedKeyContext();
        List columnNames = insertStatementContext.getColumnNames();
        if (generatedKey.isPresent() && ((GeneratedKeyContext)generatedKey.get()).isGenerated()) {
            LinkedHashSet<String> result = new LinkedHashSet<String>(columnNames);
            result.remove(((GeneratedKeyContext)generatedKey.get()).getColumnName());
            return result;
        }
        return new LinkedHashSet<String>(columnNames);
    }

    private ShardingCondition createShardingCondition(String tableName, Iterator<String> columnNames, InsertValueContext insertValueContext, List<Object> params, int rowNumber) {
        ShardingCondition result = new ShardingCondition();
        for (ExpressionSegment each : insertValueContext.getValueExpressions()) {
            if (!columnNames.hasNext()) {
                throw new InsertColumnsAndValuesMismatchedException(rowNumber);
            }
            Optional<String> shardingColumn = this.shardingRule.findShardingColumn(columnNames.next(), tableName);
            if (!shardingColumn.isPresent()) continue;
            if (each instanceof SimpleExpressionSegment) {
                List<Integer> parameterMarkerIndexes = each instanceof ParameterMarkerExpressionSegment ? Collections.singletonList(((ParameterMarkerExpressionSegment)each).getParameterMarkerIndex()) : Collections.emptyList();
                Object shardingValue = this.getShardingValue((SimpleExpressionSegment)each, params);
                result.getValues().add(new ListShardingConditionValue<Object>(shardingColumn.get(), tableName, Collections.singletonList(shardingValue), parameterMarkerIndexes));
                continue;
            }
            if (each instanceof CommonExpressionSegment) {
                this.generateShardingCondition((CommonExpressionSegment)each, result, shardingColumn.get(), tableName);
                continue;
            }
            if (!ExpressionConditionUtils.isNowExpression(each)) continue;
            result.getValues().add(new ListShardingConditionValue<Timestamp>(shardingColumn.get(), tableName, Collections.singletonList(this.timestampServiceRule.getTimestamp())));
        }
        return result;
    }

    private void generateShardingCondition(CommonExpressionSegment expressionSegment, ShardingCondition condition, String shardingColumn, String tableName) {
        try {
            Integer value = Integer.valueOf(expressionSegment.getText());
            condition.getValues().add(new ListShardingConditionValue<Integer>(shardingColumn, tableName, Collections.singletonList(value)));
        }
        catch (NumberFormatException ex) {
            condition.getValues().add(new ListShardingConditionValue<String>(shardingColumn, tableName, Collections.singletonList(expressionSegment.getText())));
        }
    }

    private Object getShardingValue(SimpleExpressionSegment expressionSegment, List<Object> params) {
        return expressionSegment instanceof ParameterMarkerExpressionSegment ? params.get(((ParameterMarkerExpressionSegment)expressionSegment).getParameterMarkerIndex()) : ((LiteralExpressionSegment)expressionSegment).getLiterals();
    }

    private List<ShardingCondition> createShardingConditionsWithInsertSelect(InsertStatementContext sqlStatementContext, List<Object> params) {
        SelectStatementContext selectStatementContext = sqlStatementContext.getInsertSelectContext().getSelectStatementContext();
        return new LinkedList<ShardingCondition>(new WhereClauseShardingConditionEngine(this.database, this.shardingRule, this.timestampServiceRule).createShardingConditions((SQLStatementContext)selectStatementContext, params));
    }

    private void appendGeneratedKeyConditions(InsertStatementContext sqlStatementContext, List<ShardingCondition> shardingConditions) {
        Optional generatedKey = sqlStatementContext.getGeneratedKeyContext();
        String tableName = sqlStatementContext.getSqlStatement().getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        if (generatedKey.isPresent() && ((GeneratedKeyContext)generatedKey.get()).isGenerated() && this.shardingRule.findShardingTable(tableName).isPresent()) {
            String schemaName = sqlStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(this.database.getName()));
            AlgorithmSQLContext algorithmSQLContext = new AlgorithmSQLContext(this.database.getName(), schemaName, tableName, ((GeneratedKeyContext)generatedKey.get()).getColumnName());
            ((GeneratedKeyContext)generatedKey.get()).getGeneratedValues().addAll(this.shardingRule.generateKeys(algorithmSQLContext, sqlStatementContext.getValueListCount()));
            ((GeneratedKeyContext)generatedKey.get()).setSupportAutoIncrement(this.shardingRule.isSupportAutoIncrement(tableName));
            if (this.shardingRule.findShardingColumn(((GeneratedKeyContext)generatedKey.get()).getColumnName(), tableName).isPresent()) {
                this.appendGeneratedKeyCondition((GeneratedKeyContext)generatedKey.get(), tableName, shardingConditions);
            }
        }
    }

    private void appendGeneratedKeyCondition(GeneratedKeyContext generatedKey, String tableName, List<ShardingCondition> shardingConditions) {
        Iterator generatedValuesIterator = generatedKey.getGeneratedValues().iterator();
        for (ShardingCondition each : shardingConditions) {
            each.getValues().add(new ListShardingConditionValue<Comparable>(generatedKey.getColumnName(), tableName, Collections.singletonList((Comparable)generatedValuesIterator.next())));
        }
    }

    @Generated
    public InsertClauseShardingConditionEngine(ShardingSphereDatabase database, ShardingRule shardingRule, TimestampServiceRule timestampServiceRule) {
        this.database = database;
        this.shardingRule = shardingRule;
        this.timestampServiceRule = timestampServiceRule;
    }
}

