/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.connection;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.shardingsphere.driver.exception.ConnectionClosedException;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractConnectionAdapter;
import org.apache.shardingsphere.driver.jdbc.adapter.executor.ForceExecuteTemplate;
import org.apache.shardingsphere.driver.jdbc.core.connection.DriverDatabaseConnectionManager;
import org.apache.shardingsphere.driver.jdbc.core.datasource.metadata.ShardingSphereDatabaseMetaData;
import org.apache.shardingsphere.driver.jdbc.core.statement.ShardingSpherePreparedStatement;
import org.apache.shardingsphere.driver.jdbc.core.statement.ShardingSphereStatement;
import org.apache.shardingsphere.driver.jdbc.core.statement.StatementManager;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.transaction.ConnectionTransaction;
import org.apache.shardingsphere.transaction.rule.TransactionRule;

public final class ShardingSphereConnection
extends AbstractConnectionAdapter {
    private final ProcessEngine processEngine = new ProcessEngine();
    private final ForceExecuteTemplate<StatementManager> forceExecuteTemplate = new ForceExecuteTemplate();
    private final String currentDatabaseName;
    private final ContextManager contextManager;
    private final DriverDatabaseConnectionManager databaseConnectionManager;
    private final Collection<StatementManager> statementManagers = new CopyOnWriteArrayList<StatementManager>();
    private final String processId;
    private final String executorType;
    private boolean autoCommit = true;
    private int transactionIsolation = 1;
    private boolean readOnly;
    private volatile boolean closed;

    public ShardingSphereConnection(String currentDatabaseName, ContextManager contextManager, String executorType) {
        this.currentDatabaseName = currentDatabaseName;
        this.contextManager = contextManager;
        this.databaseConnectionManager = new DriverDatabaseConnectionManager(currentDatabaseName, contextManager);
        this.processId = this.processEngine.connect(currentDatabaseName);
        this.executorType = executorType;
    }

    public void beginTransactionIfNeededWhenAutoCommitFalse() throws SQLException {
        if (this.autoCommit || this.databaseConnectionManager.getConnectionContext().getTransactionContext().isInTransaction()) {
            return;
        }
        this.databaseConnectionManager.begin();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new ShardingSphereDatabaseMetaData(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, this.executorType);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, resultSetType, resultSetConcurrency, this.executorType);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, this.executorType);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, autoGeneratedKeys, this.executorType);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, 1, this.executorType);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, columnNames, this.executorType);
    }

    @Override
    public Statement createStatement() {
        return new ShardingSphereStatement(this, this.executorType);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new ShardingSphereStatement(this, resultSetType, resultSetConcurrency, this.executorType);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new ShardingSphereStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability, this.executorType);
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
        if (this.databaseConnectionManager.getConnectionTransaction().isLocalTransaction()) {
            this.processLocalTransaction();
        } else {
            this.processDistributedTransaction();
        }
    }

    private void processLocalTransaction() throws SQLException {
        this.databaseConnectionManager.setAutoCommit(this.autoCommit);
        TransactionConnectionContext transactionContext = this.databaseConnectionManager.getConnectionContext().getTransactionContext();
        if (this.autoCommit && transactionContext.isInTransaction()) {
            transactionContext.close();
            return;
        }
        if (!this.autoCommit && !transactionContext.isInTransaction()) {
            transactionContext.beginTransaction(String.valueOf(((TransactionRule)this.contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(TransactionRule.class)).getDefaultType()));
        }
    }

    private void processDistributedTransaction() throws SQLException {
        Optional operationType = this.databaseConnectionManager.getConnectionTransaction().getDistributedTransactionOperationType(this.autoCommit);
        if (!operationType.isPresent()) {
            return;
        }
        if (ConnectionTransaction.DistributedTransactionOperationType.BEGIN == operationType.get()) {
            this.databaseConnectionManager.begin();
        } else {
            this.databaseConnectionManager.commit();
        }
    }

    @Override
    public void commit() throws SQLException {
        this.databaseConnectionManager.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.databaseConnectionManager.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClose();
        ShardingSpherePreconditions.checkState((this.databaseConnectionManager.getConnectionTransaction().isHoldTransaction(this.autoCommit) || !this.isSchemaSupportedDatabaseType() ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("ROLLBACK TO SAVEPOINT can only be used in transaction blocks"));
        this.databaseConnectionManager.rollback(savepoint);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClose();
        ShardingSpherePreconditions.checkState((this.databaseConnectionManager.getConnectionTransaction().isHoldTransaction(this.autoCommit) || !this.isSchemaSupportedDatabaseType() ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("Savepoint can only be used in transaction blocks"));
        return this.databaseConnectionManager.setSavepoint(name);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClose();
        ShardingSpherePreconditions.checkState((this.databaseConnectionManager.getConnectionTransaction().isHoldTransaction(this.autoCommit) || !this.isSchemaSupportedDatabaseType() ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("Savepoint can only be used in transaction blocks"));
        return this.databaseConnectionManager.setSavepoint();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClose();
        ShardingSpherePreconditions.checkState((this.databaseConnectionManager.getConnectionTransaction().isHoldTransaction(this.autoCommit) || !this.isSchemaSupportedDatabaseType() ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("RELEASE SAVEPOINT can only be used in transaction blocks"));
        if (this.databaseConnectionManager.getConnectionTransaction().isHoldTransaction(this.autoCommit)) {
            this.databaseConnectionManager.releaseSavepoint(savepoint);
        }
    }

    private void checkClose() throws SQLException {
        ShardingSpherePreconditions.checkState((!this.isClosed() ? 1 : 0) != 0, () -> new ConnectionClosedException().toSQLException());
    }

    private boolean isSchemaSupportedDatabaseType() {
        DatabaseType databaseType = this.contextManager.getMetaDataContexts().getMetaData().getDatabase(this.currentDatabaseName).getProtocolType();
        return new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getDefaultSchema().isPresent();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.databaseConnectionManager.getTransactionIsolation().orElseGet(() -> this.transactionIsolation);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.transactionIsolation = level;
        this.databaseConnectionManager.setTransactionIsolation(level);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
        this.databaseConnectionManager.setReadOnly(readOnly);
    }

    @Override
    public int getNetworkTimeout() {
        return 0;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        ShardingSpherePreconditions.checkState((0 <= milliseconds ? 1 : 0) != 0, () -> new SQLException("Network timeout must be a value greater than or equal to 0."));
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.databaseConnectionManager.isValid(timeout);
    }

    @Override
    public String getSchema() {
        return this.currentDatabaseName;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws SQLException {
        if (this.databaseConnectionManager.getConnectionTransaction().isInDistributedTransaction(this.databaseConnectionManager.getConnectionContext().getTransactionContext())) {
            this.databaseConnectionManager.getConnectionTransaction().rollback();
        }
        this.closed = true;
        this.processEngine.disconnect(this.processId);
        try {
            this.forceExecuteTemplate.execute(this.statementManagers, StatementManager::close);
        }
        finally {
            this.statementManagers.clear();
            this.databaseConnectionManager.close();
        }
    }

    @Generated
    public String getCurrentDatabaseName() {
        return this.currentDatabaseName;
    }

    @Generated
    public ContextManager getContextManager() {
        return this.contextManager;
    }

    @Generated
    public DriverDatabaseConnectionManager getDatabaseConnectionManager() {
        return this.databaseConnectionManager;
    }

    @Generated
    public Collection<StatementManager> getStatementManagers() {
        return this.statementManagers;
    }

    @Generated
    public String getProcessId() {
        return this.processId;
    }
}

