/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.preparer.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.metadata.generator.PipelineDDLGenerator;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.option.DialectPipelineJobDataSourcePrepareOption;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.param.CreateTableConfiguration;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.param.PrepareTargetSchemasParameter;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.param.PrepareTargetTablesParameter;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql.PipelinePrepareSQLBuilder;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineJobDataSourcePreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineJobDataSourcePreparer.class);
    private static final Pattern PATTERN_CREATE_TABLE_IF_NOT_EXISTS = Pattern.compile("CREATE\\s+TABLE\\s+IF\\s+NOT\\s+EXISTS\\s+", 2);
    private static final Pattern PATTERN_CREATE_TABLE = Pattern.compile("CREATE\\s+TABLE\\s+", 2);
    private final DatabaseType databaseType;

    public void prepareTargetSchemas(PrepareTargetSchemasParameter param) throws SQLException {
        DatabaseType targetDatabaseType = param.getTargetDatabaseType();
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(targetDatabaseType).getDialectDatabaseMetaData();
        if (!dialectDatabaseMetaData.isSchemaAvailable()) {
            return;
        }
        String defaultSchema = dialectDatabaseMetaData.getDefaultSchema().orElse(null);
        PipelinePrepareSQLBuilder pipelineSQLBuilder = new PipelinePrepareSQLBuilder(targetDatabaseType);
        HashSet<String> createdSchemaNames = new HashSet<String>(param.getCreateTableConfigurations().size(), 1.0f);
        for (CreateTableConfiguration each : param.getCreateTableConfigurations()) {
            Optional<String> sql;
            String targetSchemaName = each.getTargetName().getSchemaName().toString();
            if (null == targetSchemaName || targetSchemaName.equalsIgnoreCase(defaultSchema) || createdSchemaNames.contains(targetSchemaName) || !(sql = pipelineSQLBuilder.buildCreateSchemaSQL(targetSchemaName)).isPresent()) continue;
            this.executeCreateSchema(param.getDataSourceManager(), each.getTargetDataSourceConfig(), sql.get());
            createdSchemaNames.add(targetSchemaName);
        }
    }

    private void executeCreateSchema(PipelineDataSourceManager dataSourceManager, PipelineDataSourceConfiguration targetDataSourceConfig, String sql) throws SQLException {
        log.info("Prepare target schemas SQL: {}", (Object)sql);
        try (Connection connection = dataSourceManager.getDataSource(targetDataSourceConfig).getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException ex) {
            if (DatabaseTypedSPILoader.findService(DialectPipelineJobDataSourcePrepareOption.class, (DatabaseType)this.databaseType).map(DialectPipelineJobDataSourcePrepareOption::isSupportIfNotExistsOnCreateSchema).orElse(true).booleanValue()) {
                throw ex;
            }
            log.warn("Create schema failed", (Throwable)ex);
        }
    }

    public void prepareTargetTables(PrepareTargetTablesParameter param) throws SQLException {
        long startTimeMillis = System.currentTimeMillis();
        PipelineDataSourceManager dataSourceManager = param.getDataSourceManager();
        for (CreateTableConfiguration each : param.getCreateTableConfigurations()) {
            List<String> createTargetTableSQL = this.getCreateTargetTableSQL(each, dataSourceManager, param.getSqlParserEngine());
            Connection targetConnection = dataSourceManager.getDataSource(each.getTargetDataSourceConfig()).getConnection();
            try {
                for (String sql : createTargetTableSQL) {
                    this.executeTargetTableSQL(targetConnection, this.addIfNotExistsForCreateTableSQL(sql));
                }
            }
            finally {
                if (targetConnection == null) continue;
                targetConnection.close();
            }
        }
        log.info("prepareTargetTables cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    private void executeTargetTableSQL(Connection targetConnection, String sql) throws SQLException {
        log.info("Execute target table SQL: {}", (Object)sql);
        try (Statement statement = targetConnection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException ex) {
            for (String each : (Collection)DatabaseTypedSPILoader.findService(DialectPipelineJobDataSourcePrepareOption.class, (DatabaseType)this.databaseType).map(DialectPipelineJobDataSourcePrepareOption::getIgnoredExceptionMessages).orElse(Collections.emptyList())) {
                if (!ex.getMessage().contains(each)) continue;
                return;
            }
            throw ex;
        }
    }

    private String addIfNotExistsForCreateTableSQL(String createTableSQL) {
        return PATTERN_CREATE_TABLE_IF_NOT_EXISTS.matcher(createTableSQL).find() ? createTableSQL : PATTERN_CREATE_TABLE.matcher(createTableSQL).replaceFirst("CREATE TABLE IF NOT EXISTS ");
    }

    private List<String> getCreateTargetTableSQL(CreateTableConfiguration createTableConfig, PipelineDataSourceManager dataSourceManager, SQLParserEngine sqlParserEngine) throws SQLException {
        DatabaseType databaseType = createTableConfig.getSourceDataSourceConfig().getDatabaseType();
        PipelineDataSource sourceDataSource = dataSourceManager.getDataSource(createTableConfig.getSourceDataSourceConfig());
        String schemaName = createTableConfig.getSourceName().getSchemaName().toString();
        String sourceTableName = createTableConfig.getSourceName().getTableName().toString();
        String targetTableName = createTableConfig.getTargetName().getTableName().toString();
        return new PipelineDDLGenerator().generateLogicDDL(databaseType, sourceDataSource, schemaName, sourceTableName, targetTableName, sqlParserEngine);
    }

    @Generated
    public PipelineJobDataSourcePreparer(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

