/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ratelimit.type;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Properties;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;

public final class TPSJobRateLimitAlgorithm
implements JobRateLimitAlgorithm {
    private static final String TPS_KEY = "tps";
    private int tps = 2000;
    private RateLimiter rateLimiter;

    public void init(Properties props) {
        String tpsValue = props.getProperty(TPS_KEY);
        if (!Strings.isNullOrEmpty((String)tpsValue)) {
            this.tps = Integer.parseInt(tpsValue);
            ShardingSpherePreconditions.checkState((this.tps > 0 ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "TPS must be a positive number", new Object[0]));
        }
        this.rateLimiter = RateLimiter.create((double)this.tps);
    }

    @Override
    public void intercept(PipelineSQLOperationType type, Number data) {
        switch (type) {
            case INSERT: 
            case DELETE: 
            case UPDATE: {
                this.rateLimiter.acquire(null != data ? data.intValue() : 1);
                break;
            }
        }
    }

    public String getType() {
        return "TPS";
    }
}

