/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.infra.metadata.caseinsensitive.CaseInsensitiveIdentifier;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.ShardingRuleConfigurationConverter;

public final class ShardingColumnsExtractor {
    public Map<CaseInsensitiveIdentifier, Set<String>> getShardingColumnsMap(Collection<YamlRuleConfiguration> yamlRuleConfigs, Set<CaseInsensitiveIdentifier> logicTableNames) {
        CaseInsensitiveIdentifier logicTableName;
        Optional shardingRuleConfig = ShardingRuleConfigurationConverter.findAndConvertShardingRuleConfiguration(yamlRuleConfigs);
        if (!shardingRuleConfig.isPresent()) {
            return Collections.emptyMap();
        }
        Set<String> defaultDatabaseShardingColumns = this.extractShardingColumns(((ShardingRuleConfiguration)shardingRuleConfig.get()).getDefaultDatabaseShardingStrategy());
        Set<String> defaultTableShardingColumns = this.extractShardingColumns(((ShardingRuleConfiguration)shardingRuleConfig.get()).getDefaultTableShardingStrategy());
        ConcurrentHashMap<CaseInsensitiveIdentifier, Set<String>> result = new ConcurrentHashMap<CaseInsensitiveIdentifier, Set<String>>(((ShardingRuleConfiguration)shardingRuleConfig.get()).getTables().size(), 1.0f);
        for (ShardingTableRuleConfiguration each : ((ShardingRuleConfiguration)shardingRuleConfig.get()).getTables()) {
            logicTableName = new CaseInsensitiveIdentifier(each.getLogicTable());
            if (!logicTableNames.contains(logicTableName)) continue;
            HashSet<String> shardingColumns = new HashSet<String>();
            shardingColumns.addAll(null == each.getDatabaseShardingStrategy() ? defaultDatabaseShardingColumns : this.extractShardingColumns(each.getDatabaseShardingStrategy()));
            shardingColumns.addAll(null == each.getTableShardingStrategy() ? defaultTableShardingColumns : this.extractShardingColumns(each.getTableShardingStrategy()));
            result.put(logicTableName, shardingColumns);
        }
        for (ShardingTableRuleConfiguration each : ((ShardingRuleConfiguration)shardingRuleConfig.get()).getAutoTables()) {
            logicTableName = new CaseInsensitiveIdentifier(each.getLogicTable());
            if (!logicTableNames.contains(logicTableName)) continue;
            ShardingStrategyConfiguration shardingStrategy = each.getShardingStrategy();
            HashSet<String> shardingColumns = new HashSet<String>(this.extractShardingColumns(shardingStrategy));
            result.put(logicTableName, shardingColumns);
        }
        return result;
    }

    private Set<String> extractShardingColumns(ShardingStrategyConfiguration shardingStrategy) {
        if (shardingStrategy instanceof StandardShardingStrategyConfiguration) {
            return new HashSet<String>(Collections.singleton(((StandardShardingStrategyConfiguration)shardingStrategy).getShardingColumn()));
        }
        if (shardingStrategy instanceof ComplexShardingStrategyConfiguration) {
            return new HashSet<String>(Arrays.asList(((ComplexShardingStrategyConfiguration)shardingStrategy).getShardingColumns().split(",")));
        }
        return Collections.emptySet();
    }
}

