/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.workerid;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdAssignedException;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.mode.manager.cluster.persist.ReservationPersistService;
import org.apache.shardingsphere.mode.persist.service.ComputeNodePersistService;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.spi.PersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterWorkerIdGenerator
implements WorkerIdGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterWorkerIdGenerator.class);
    private final String instanceId;
    private final ComputeNodePersistService computeNodePersistService;
    private final ReservationPersistService reservationPersistService;
    private final AtomicBoolean isWarned = new AtomicBoolean(false);

    public ClusterWorkerIdGenerator(ClusterPersistRepository repository, String instanceId) {
        this.instanceId = instanceId;
        this.computeNodePersistService = new ComputeNodePersistService((PersistRepository)repository);
        this.reservationPersistService = new ReservationPersistService(repository);
    }

    public int generate(Properties props) {
        int result = this.computeNodePersistService.loadInstanceWorkerId(this.instanceId).orElseGet(this::generateNewWorkerId);
        this.logWarning(result, props);
        return result;
    }

    private int generateNewWorkerId() {
        Optional<Integer> generatedWorkId;
        while (!(generatedWorkId = this.generateAvailableWorkerId()).isPresent()) {
        }
        int result = generatedWorkId.get();
        this.computeNodePersistService.persistInstanceWorkerId(this.instanceId, result);
        return result;
    }

    private Optional<Integer> generateAvailableWorkerId() {
        Collection assignedWorkerIds = this.computeNodePersistService.getAssignedWorkerIds();
        ShardingSpherePreconditions.checkState((assignedWorkerIds.size() <= 1024 ? 1 : 0) != 0, WorkerIdAssignedException::new);
        PriorityQueue availableWorkerIds = IntStream.range(0, 1024).boxed().filter(each -> !assignedWorkerIds.contains(each)).collect(Collectors.toCollection(PriorityQueue::new));
        Integer preselectedWorkerId = (Integer)availableWorkerIds.poll();
        Preconditions.checkNotNull((Object)preselectedWorkerId, (Object)"Preselected worker-id can not be null.");
        return this.reservationPersistService.reserveWorkerId(preselectedWorkerId, this.instanceId);
    }

    private void logWarning(int generatedWorkerId, Properties props) {
        if (!this.isWarned.get() && props.containsKey("worker-id")) {
            this.isWarned.set(true);
            log.warn("It is unnecessary to configure {} in cluster mode, system assigned {} was {}", new Object[]{"worker-id", "worker-id", generatedWorkerId});
        }
    }
}

