/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.plugin.classloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public final class AgentPluginClassLoader
extends ClassLoader {
    private final Collection<JarFile> extraJars;

    public AgentPluginClassLoader(ClassLoader appClassLoader, Collection<JarFile> extraJars) {
        super(appClassLoader);
        this.extraJars = extraJars;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = this.convertClassNameToPath(name);
        for (JarFile each : this.extraJars) {
            ZipEntry entry = each.getEntry(path);
            if (null == entry) continue;
            try {
                this.definePackage(name, each);
                return this.defineClass(name, each, entry);
            }
            catch (IOException ex) {
                throw new ClassNotFoundException(name, ex);
            }
        }
        throw new ClassNotFoundException(name);
    }

    private String convertClassNameToPath(String className) {
        return String.join((CharSequence)"", className.replace(".", "/"), ".class");
    }

    private void definePackage(String className, JarFile extraJar) throws IOException {
        int index = className.lastIndexOf(46);
        if (-1 == index) {
            return;
        }
        String packageName = className.substring(0, index);
        if (null == this.getPackage(packageName)) {
            this.definePackage(packageName, extraJar.getManifest());
        }
    }

    private void definePackage(String name, Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
        String specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
        String specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
        String implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        String implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        String implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
    }

    private Class<?> defineClass(String name, JarFile extraJar, ZipEntry entry) throws IOException {
        byte[] data = AgentPluginClassLoader.toByteArray(extraJar.getInputStream(entry));
        return this.defineClass(name, data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toByteArray(InputStream inStream) throws IOException {
        int buffSize = 2048;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[buffSize];
            while ((len = inStream.read(buffer)) != -1) {
                result.write(buffer, 0, len);
            }
        }
        finally {
            result.close();
            inStream.close();
        }
        return result.toByteArray();
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        LinkedList result = new LinkedList();
        for (JarFile each : this.extraJars) {
            this.findResource(name, each).ifPresent(result::add);
        }
        return Collections.enumeration(result);
    }

    @Override
    protected URL findResource(String name) {
        return this.extraJars.stream().map(each -> this.findResource(name, (JarFile)each)).filter(Optional::isPresent).findFirst().filter(Optional::isPresent).map(Optional::get).orElse(null);
    }

    private Optional<URL> findResource(String name, JarFile extraJar) {
        JarEntry entry = extraJar.getJarEntry(name);
        if (null == entry) {
            return Optional.empty();
        }
        try {
            return Optional.of(new URL(String.format("jar:file:%s!/%s", extraJar.getName(), name)));
        }
        catch (MalformedURLException ignored) {
            return Optional.empty();
        }
    }

    static {
        AgentPluginClassLoader.registerAsParallelCapable();
    }
}

