/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.hikari.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.infra.datasource.pool.hikari.metadata.HikariDataSourcePoolFieldMetaData;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;

public final class HikariDataSourcePoolMetaData
implements DataSourcePoolMetaData {
    private static final Map<String, Object> DEFAULT_PROPS = new HashMap<String, Object>(6, 1.0f);
    private static final Map<String, Object> SKIPPED_PROPS = new HashMap<String, Object>(2, 1.0f);
    private static final Map<String, String> PROP_SYNONYMS = new HashMap<String, String>(6, 1.0f);
    private static final Collection<String> TRANSIENT_FIELD_NAMES = new LinkedList<String>();

    private static void buildDefaultProperties() {
        DEFAULT_PROPS.put("connectionTimeout", 30000L);
        DEFAULT_PROPS.put("idleTimeout", 60000L);
        DEFAULT_PROPS.put("maxLifetime", 0x200B20L);
        DEFAULT_PROPS.put("maximumPoolSize", 50);
        DEFAULT_PROPS.put("minimumIdle", 1);
        DEFAULT_PROPS.put("readOnly", false);
        DEFAULT_PROPS.put("keepaliveTime", 0);
    }

    private static void buildInvalidProperties() {
        SKIPPED_PROPS.put("minimumIdle", -1);
        SKIPPED_PROPS.put("maximumPoolSize", -1);
    }

    private static void buildPropertySynonyms() {
        PROP_SYNONYMS.put("url", "jdbcUrl");
        PROP_SYNONYMS.put("connectionTimeoutMilliseconds", "connectionTimeout");
        PROP_SYNONYMS.put("idleTimeoutMilliseconds", "idleTimeout");
        PROP_SYNONYMS.put("maxLifetimeMilliseconds", "maxLifetime");
        PROP_SYNONYMS.put("maxPoolSize", "maximumPoolSize");
        PROP_SYNONYMS.put("minPoolSize", "minimumIdle");
    }

    private static void buildTransientFieldNames() {
        TRANSIENT_FIELD_NAMES.add("running");
        TRANSIENT_FIELD_NAMES.add("poolName");
        TRANSIENT_FIELD_NAMES.add("closed");
    }

    public Map<String, Object> getDefaultProperties() {
        return DEFAULT_PROPS;
    }

    public Map<String, Object> getSkippedProperties() {
        return SKIPPED_PROPS;
    }

    public Map<String, String> getPropertySynonyms() {
        return PROP_SYNONYMS;
    }

    public Collection<String> getTransientFieldNames() {
        return TRANSIENT_FIELD_NAMES;
    }

    public HikariDataSourcePoolFieldMetaData getFieldMetaData() {
        return new HikariDataSourcePoolFieldMetaData();
    }

    public String getType() {
        return "com.zaxxer.hikari.HikariDataSource";
    }

    public boolean isDefault() {
        return true;
    }

    static {
        HikariDataSourcePoolMetaData.buildDefaultProperties();
        HikariDataSourcePoolMetaData.buildInvalidProperties();
        HikariDataSourcePoolMetaData.buildPropertySynonyms();
        HikariDataSourcePoolMetaData.buildTransientFieldNames();
    }
}

