/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.rule;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttributes;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.transaction.ConnectionTransaction;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.api.TransactionType;
import org.apache.shardingsphere.transaction.config.TransactionRuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionRule
implements GlobalRule,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionRule.class);
    private final TransactionRuleConfiguration configuration;
    private final TransactionType defaultType;
    private final String providerType;
    private final Properties props;
    private final AtomicReference<ShardingSphereTransactionManagerEngine> resource;
    private final RuleAttributes attributes;

    public TransactionRule(TransactionRuleConfiguration ruleConfig, Collection<ShardingSphereDatabase> databases) {
        this.configuration = ruleConfig;
        this.defaultType = TransactionType.valueOf((String)ruleConfig.getDefaultType().toUpperCase());
        this.providerType = ruleConfig.getProviderType();
        this.props = ruleConfig.getProps();
        this.resource = new AtomicReference<ShardingSphereTransactionManagerEngine>(this.createTransactionManagerEngine(databases));
        this.attributes = new RuleAttributes(new RuleAttribute[0]);
    }

    private synchronized ShardingSphereTransactionManagerEngine createTransactionManagerEngine(Collection<ShardingSphereDatabase> databases) {
        ShardingSphereTransactionManagerEngine result = new ShardingSphereTransactionManagerEngine(this.defaultType);
        if (databases.isEmpty()) {
            return result;
        }
        LinkedHashMap<String, DatabaseType> databaseTypes = new LinkedHashMap<String, DatabaseType>(databases.size(), 1.0f);
        LinkedHashMap<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>(databases.size(), 1.0f);
        for (ShardingSphereDatabase each : databases) {
            each.getResourceMetaData().getStorageUnits().forEach((key, value) -> {
                databaseTypes.put(each.getName() + "." + key, value.getStorageType());
                dataSourceMap.put(each.getName() + "." + key, value.getDataSource());
            });
        }
        result.init(databaseTypes, dataSourceMap, this.providerType);
        return result;
    }

    public ShardingSphereTransactionManagerEngine getResource() {
        return this.resource.get();
    }

    public boolean isImplicitCommitTransaction(ExecutionContext executionContext, ConnectionTransaction connectionTransaction, boolean isAutoCommit) {
        if (!isAutoCommit) {
            return false;
        }
        if (!TransactionType.isDistributedTransaction((TransactionType)this.defaultType) || connectionTransaction.isInDistributedTransaction()) {
            return false;
        }
        return this.isWriteDMLStatement(executionContext.getSqlStatementContext().getSqlStatement()) && executionContext.getExecutionUnits().size() > 1;
    }

    private boolean isWriteDMLStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof DMLStatement && !(sqlStatement instanceof SelectStatement);
    }

    public void refresh(Collection<ShardingSphereDatabase> databases, GlobalRule.GlobalRuleChangedType changedType) {
        if (GlobalRule.GlobalRuleChangedType.DATABASE_CHANGED != changedType) {
            return;
        }
        ShardingSphereTransactionManagerEngine previousEngine = this.resource.get();
        this.close(previousEngine);
        this.resource.set(this.createTransactionManagerEngine(databases));
    }

    @Override
    public void close() {
        ShardingSphereTransactionManagerEngine engine = this.resource.get();
        if (null != engine) {
            this.close(engine);
            this.resource.set(new ShardingSphereTransactionManagerEngine(this.defaultType));
        }
    }

    private void close(ShardingSphereTransactionManagerEngine engine) {
        try {
            engine.close();
        }
        catch (RuntimeException ex) {
            log.error("Close transaction engine failed.", (Throwable)ex);
        }
    }

    public int getOrder() {
        return 600;
    }

    @Generated
    public TransactionRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public TransactionType getDefaultType() {
        return this.defaultType;
    }

    @Generated
    public String getProviderType() {
        return this.providerType;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public RuleAttributes getAttributes() {
        return this.attributes;
    }
}

