/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.database;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.authority.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.authority.model.ShardingSpherePrivileges;
import org.apache.shardingsphere.authority.provider.database.DatabasePermittedPrivileges;
import org.apache.shardingsphere.authority.spi.PrivilegeProvider;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;

public final class DatabasePermittedPrivilegeProvider
implements PrivilegeProvider {
    private static final String USER_DATABASE_MAPPINGS_KEY = "user-database-mappings";
    private String userDatabasesMappings;

    public void init(Properties props) {
        this.userDatabasesMappings = props.getProperty(USER_DATABASE_MAPPINGS_KEY, "");
        this.checkUserDatabasesMappings();
    }

    private void checkUserDatabasesMappings() {
        Preconditions.checkArgument((!"".equals(this.userDatabasesMappings) ? 1 : 0) != 0, (String)"user-database-mappings configuration `%s` can not be null", (Object)this.userDatabasesMappings);
        Arrays.stream(this.userDatabasesMappings.split(",")).forEach(each -> Preconditions.checkArgument((each.contains("@") && each.contains("=") ? 1 : 0) != 0, (String)"user-database-mappings configuration `%s` is invalid, the configuration format should be like `username@hostname=database`", (Object)each));
    }

    public ShardingSpherePrivileges build(AuthorityRuleConfiguration ruleConfig, Grantee grantee) {
        Map<ShardingSphereUser, Collection<String>> userDatabasesMappings = this.convertToUserDatabasesMappings();
        return new DatabasePermittedPrivileges(this.getUserDatabases(grantee, userDatabasesMappings));
    }

    private Map<ShardingSphereUser, Collection<String>> convertToUserDatabasesMappings() {
        String[] mappings = this.userDatabasesMappings.split(",");
        HashMap<ShardingSphereUser, Collection<String>> result = new HashMap<ShardingSphereUser, Collection<String>>(mappings.length, 1.0f);
        for (String each : mappings) {
            String[] userDatabasePair = each.trim().split("=");
            ShardingSphereUser user = new ShardingSphereUser(userDatabasePair[0]);
            Collection databases = result.getOrDefault(user, new HashSet());
            databases.add(userDatabasePair[1]);
            result.putIfAbsent(user, databases);
        }
        return result;
    }

    private Collection<String> getUserDatabases(Grantee grantee, Map<ShardingSphereUser, Collection<String>> userDatabasesMappings) {
        return userDatabasesMappings.entrySet().stream().filter(entry -> ((ShardingSphereUser)entry.getKey()).getGrantee().accept(grantee)).flatMap(entry -> ((Collection)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    public String getType() {
        return "DATABASE_PERMITTED";
    }

    public Collection<Object> getTypeAliases() {
        return Collections.singleton("SCHEMA_PRIVILEGES_PERMITTED");
    }
}

