/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.transaction.TableModifyInTransactionException;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.raw.RawExecutionPrepareEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.raw.RawExecutionRuleAttribute;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseConnector;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.ProxyJDBCExecutor;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.connector.sane.SaneQueryResultEngine;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.session.transaction.TransactionStatus;
import org.apache.shardingsphere.proxy.backend.util.TransactionUtils;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionIsolationLevel;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CloseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.FetchStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.MoveStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.TruncateStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dml.MySQLInsertStatement;
import org.apache.shardingsphere.sql.parser.statement.opengauss.OpenGaussStatement;
import org.apache.shardingsphere.sql.parser.statement.opengauss.ddl.OpenGaussCursorStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.PostgreSQLStatement;
import org.apache.shardingsphere.sqlfederation.engine.SQLFederationEngine;
import org.apache.shardingsphere.transaction.api.TransactionType;
import org.apache.shardingsphere.transaction.spi.TransactionHook;

public final class ProxySQLExecutor {
    private final String type;
    private final ProxyDatabaseConnectionManager databaseConnectionManager;
    private final ProxyJDBCExecutor regularExecutor;
    private final RawExecutor rawExecutor;
    private final SQLFederationEngine sqlFederationEngine;
    private final Map<ShardingSphereRule, TransactionHook> transactionHooks = OrderedSPILoader.getServices(TransactionHook.class, (Collection)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules());

    public ProxySQLExecutor(String type, ProxyDatabaseConnectionManager databaseConnectionManager, DatabaseConnector databaseConnector, QueryContext queryContext) {
        this.type = type;
        this.databaseConnectionManager = databaseConnectionManager;
        ExecutorEngine executorEngine = BackendExecutorContext.getInstance().getExecutorEngine();
        ConnectionContext connectionContext = databaseConnectionManager.getConnectionSession().getConnectionContext();
        JDBCExecutor jdbcExecutor = new JDBCExecutor(executorEngine, connectionContext);
        this.regularExecutor = new ProxyJDBCExecutor(type, databaseConnectionManager.getConnectionSession(), databaseConnector, jdbcExecutor);
        this.rawExecutor = new RawExecutor(executorEngine, connectionContext);
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        String currentDatabaseName = Strings.isNullOrEmpty((String)databaseConnectionManager.getConnectionSession().getCurrentDatabaseName()) ? databaseConnectionManager.getConnectionSession().getUsedDatabaseName() : databaseConnectionManager.getConnectionSession().getCurrentDatabaseName();
        String currentSchemaName = this.getSchemaName(queryContext.getSqlStatementContext(), metaDataContexts.getMetaData().getDatabase(currentDatabaseName));
        this.sqlFederationEngine = new SQLFederationEngine(currentDatabaseName, currentSchemaName, metaDataContexts.getMetaData(), metaDataContexts.getStatistics(), jdbcExecutor);
    }

    private String getSchemaName(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName());
        return sqlStatementContext instanceof TableAvailable ? ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName().orElse(defaultSchemaName) : defaultSchemaName;
    }

    public void checkExecutePrerequisites(ExecutionContext executionContext) {
        ShardingSpherePreconditions.checkState((boolean)this.isValidExecutePrerequisites(executionContext), () -> new TableModifyInTransactionException(this.getTableName(executionContext)));
    }

    private boolean isValidExecutePrerequisites(ExecutionContext executionContext) {
        return !this.isExecuteDDLInXATransaction(executionContext.getSqlStatementContext().getSqlStatement()) && !this.isExecuteDDLInPostgreSQLOpenGaussTransaction(executionContext.getSqlStatementContext().getSqlStatement());
    }

    private boolean isExecuteDDLInXATransaction(SQLStatement sqlStatement) {
        TransactionType transactionType = TransactionUtils.getTransactionType(this.databaseConnectionManager.getConnectionSession().getConnectionContext().getTransactionContext());
        TransactionStatus transactionStatus = this.databaseConnectionManager.getConnectionSession().getTransactionStatus();
        return TransactionType.XA == transactionType && transactionStatus.isInTransaction() && this.isUnsupportedDDLStatement(sqlStatement);
    }

    private boolean isExecuteDDLInPostgreSQLOpenGaussTransaction(SQLStatement sqlStatement) {
        boolean isPostgreSQLOpenGaussStatement = this.isPostgreSQLOrOpenGaussStatement(sqlStatement);
        boolean isSupportedStatement = this.isSupportedSQLStatement(sqlStatement);
        return sqlStatement instanceof DDLStatement && !isSupportedStatement && isPostgreSQLOpenGaussStatement && this.databaseConnectionManager.getConnectionSession().getTransactionStatus().isInTransaction();
    }

    private boolean isSupportedSQLStatement(SQLStatement sqlStatement) {
        return this.isCursorStatement(sqlStatement) || sqlStatement instanceof TruncateStatement;
    }

    private boolean isCursorStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof OpenGaussCursorStatement || sqlStatement instanceof CloseStatement || sqlStatement instanceof MoveStatement || sqlStatement instanceof FetchStatement;
    }

    private boolean isUnsupportedDDLStatement(SQLStatement sqlStatement) {
        if (this.isPostgreSQLOrOpenGaussStatement(sqlStatement) && this.isSupportedSQLStatement(sqlStatement)) {
            return false;
        }
        return sqlStatement instanceof DDLStatement;
    }

    private boolean isPostgreSQLOrOpenGaussStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof PostgreSQLStatement || sqlStatement instanceof OpenGaussStatement;
    }

    private String getTableName(ExecutionContext executionContext) {
        return executionContext.getSqlStatementContext() instanceof TableAvailable && !((TableAvailable)executionContext.getSqlStatementContext()).getTablesContext().getSimpleTables().isEmpty() ? ((SimpleTableSegment)((TableAvailable)executionContext.getSqlStatementContext()).getTablesContext().getSimpleTables().iterator().next()).getTableName().getIdentifier().getValue() : "unknown_table";
    }

    public List<ExecuteResult> execute(ExecutionContext executionContext) throws SQLException {
        String databaseName = this.databaseConnectionManager.getConnectionSession().getUsedDatabaseName();
        Collection rules = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabase(databaseName).getRuleMetaData().getRules();
        int maxConnectionsSizePerQuery = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        boolean isReturnGeneratedKeys = executionContext.getSqlStatementContext().getSqlStatement() instanceof MySQLInsertStatement;
        return this.hasRawExecutionRule(rules) ? this.rawExecute(executionContext, rules, maxConnectionsSizePerQuery) : this.useDriverToExecute(executionContext, rules, maxConnectionsSizePerQuery, isReturnGeneratedKeys, SQLExecutorExceptionHandler.isExceptionThrown());
    }

    private boolean hasRawExecutionRule(Collection<ShardingSphereRule> rules) {
        for (ShardingSphereRule each : rules) {
            if (!each.getAttributes().findAttribute(RawExecutionRuleAttribute.class).isPresent()) continue;
            return true;
        }
        return false;
    }

    private List<ExecuteResult> rawExecute(ExecutionContext executionContext, Collection<ShardingSphereRule> rules, int maxConnectionsSizePerQuery) throws SQLException {
        ExecutionGroupContext executionGroupContext;
        RawExecutionPrepareEngine prepareEngine = new RawExecutionPrepareEngine(maxConnectionsSizePerQuery, rules);
        try {
            String databaseName = this.databaseConnectionManager.getConnectionSession().getUsedDatabaseName();
            executionGroupContext = prepareEngine.prepare(databaseName, executionContext.getRouteContext(), executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.databaseConnectionManager.getConnectionSession().getProcessId(), databaseName, this.databaseConnectionManager.getConnectionSession().getConnectionContext().getGrantee()));
        }
        catch (SQLException ex) {
            return this.getSaneExecuteResults(executionContext, ex);
        }
        return this.rawExecutor.execute(executionGroupContext, executionContext.getQueryContext(), new RawSQLExecutorCallback());
    }

    private List<ExecuteResult> useDriverToExecute(ExecutionContext executionContext, Collection<ShardingSphereRule> rules, int maxConnectionsSizePerQuery, boolean isReturnGeneratedKeys, boolean isExceptionThrown) throws SQLException {
        ExecutionGroupContext executionGroupContext;
        JDBCBackendStatement statementManager = (JDBCBackendStatement)this.databaseConnectionManager.getConnectionSession().getStatementManager();
        String databaseName = this.databaseConnectionManager.getConnectionSession().getUsedDatabaseName();
        DriverExecutionPrepareEngine prepareEngine = new DriverExecutionPrepareEngine(this.type, maxConnectionsSizePerQuery, (DatabaseConnectionManager)this.databaseConnectionManager, (ExecutorStatementManager)statementManager, (StorageResourceOption)new StatementOption(isReturnGeneratedKeys), rules, ProxyContext.getInstance().getContextManager().getDatabase(databaseName).getResourceMetaData().getStorageUnits());
        try {
            executionGroupContext = prepareEngine.prepare(databaseName, executionContext.getRouteContext(), executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.databaseConnectionManager.getConnectionSession().getProcessId(), databaseName, this.databaseConnectionManager.getConnectionSession().getConnectionContext().getGrantee()));
        }
        catch (SQLException ex) {
            return this.getSaneExecuteResults(executionContext, ex);
        }
        this.executeTransactionHooksBeforeExecuteSQL(this.databaseConnectionManager.getConnectionSession());
        return this.regularExecutor.execute(executionContext.getQueryContext(), (ExecutionGroupContext<JDBCExecutionUnit>)executionGroupContext, isReturnGeneratedKeys, isExceptionThrown);
    }

    private void executeTransactionHooksBeforeExecuteSQL(ConnectionSession connectionSession) throws SQLException {
        if (!this.getTransactionContext(connectionSession).isInTransaction()) {
            return;
        }
        for (Map.Entry<ShardingSphereRule, TransactionHook> entry : this.transactionHooks.entrySet()) {
            entry.getValue().beforeExecuteSQL(entry.getKey(), ProxyContext.getInstance().getDatabaseType(), connectionSession.getDatabaseConnectionManager().getCachedConnections().values(), this.getTransactionContext(connectionSession), connectionSession.getIsolationLevel().orElse(TransactionIsolationLevel.READ_COMMITTED));
        }
    }

    private TransactionConnectionContext getTransactionContext(ConnectionSession connectionSession) {
        return connectionSession.getDatabaseConnectionManager().getConnectionSession().getConnectionContext().getTransactionContext();
    }

    private List<ExecuteResult> getSaneExecuteResults(ExecutionContext executionContext, SQLException originalException) throws SQLException {
        DatabaseType databaseType = ProxyContext.getInstance().getContextManager().getDatabase(this.databaseConnectionManager.getConnectionSession().getUsedDatabaseName()).getProtocolType();
        Optional<ExecuteResult> executeResult = new SaneQueryResultEngine(databaseType).getSaneQueryResult(executionContext.getSqlStatementContext().getSqlStatement(), originalException);
        return executeResult.map(Collections::singletonList).orElseThrow(() -> originalException);
    }

    @Generated
    public SQLFederationEngine getSqlFederationEngine() {
        return this.sqlFederationEngine;
    }
}

