/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.ddl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.SelectStatementBinder;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateViewStatement;

public final class CreateViewStatementBinder
implements SQLStatementBinder<CreateViewStatement> {
    @Override
    public CreateViewStatement bind(CreateViewStatement sqlStatement, SQLStatementBinderContext binderContext) {
        CreateViewStatement result = CreateViewStatementBinder.copy(sqlStatement);
        LinkedHashMultimap tableBinderContexts = LinkedHashMultimap.create();
        result.setReplaceView(sqlStatement.isReplaceView());
        result.setView(SimpleTableSegmentBinder.bind(sqlStatement.getView(), binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts));
        result.setSelect(new SelectStatementBinder().bind(sqlStatement.getSelect(), binderContext));
        return result;
    }

    private static CreateViewStatement copy(CreateViewStatement sqlStatement) {
        CreateViewStatement result = (CreateViewStatement)sqlStatement.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        result.setViewDefinition(sqlStatement.getViewDefinition());
        result.addParameterMarkerSegments(sqlStatement.getParameterMarkerSegments());
        result.getCommentSegments().addAll(sqlStatement.getCommentSegments());
        result.getVariableNames().addAll(sqlStatement.getVariableNames());
        return result;
    }
}

