/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.constant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.constant.CommonConstants;
import org.apache.shardingsphere.db.protocol.constant.DatabaseProtocolDefaultVersionProvider;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;

public final class DatabaseProtocolServerInfo {
    private static final String SERVER_INFORMATION_PATTERN = "%s-ShardingSphere-Proxy %s";
    private static final Map<String, String> SERVER_INFORMATION_MAP = new ConcurrentHashMap<String, String>();

    public static void setProtocolVersion(String databaseName, String protocolVersion) {
        SERVER_INFORMATION_MAP.put(databaseName, String.format(SERVER_INFORMATION_PATTERN, protocolVersion, CommonConstants.PROXY_VERSION.get()));
    }

    public static String getProtocolVersion(String databaseName, DatabaseType databaseType) {
        return null == databaseName ? DatabaseProtocolServerInfo.getDefaultProtocolVersion(databaseType) : SERVER_INFORMATION_MAP.getOrDefault(databaseName, DatabaseProtocolServerInfo.getDefaultProtocolVersion(databaseType));
    }

    public static String getDefaultProtocolVersion(DatabaseType databaseType) {
        return String.format(SERVER_INFORMATION_PATTERN, ((DatabaseProtocolDefaultVersionProvider)DatabaseTypedSPILoader.getService(DatabaseProtocolDefaultVersionProvider.class, (DatabaseType)databaseType)).provide(), CommonConstants.PROXY_VERSION.get());
    }

    @Generated
    private DatabaseProtocolServerInfo() {
    }
}

