/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.condition.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;

public final class EncryptBinaryCondition
implements EncryptCondition {
    private final ColumnSegment columnSegment;
    private final String tableName;
    private final String operator;
    private final int startIndex;
    private final int stopIndex;
    private final ExpressionSegment expressionSegment;
    private final Map<Integer, Integer> positionIndexMap = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, Object> positionValueMap = new LinkedHashMap<Integer, Object>();

    public EncryptBinaryCondition(ColumnSegment columnSegment, String tableName, String operator, int startIndex, int stopIndex, ExpressionSegment expressionSegment) {
        this.columnSegment = columnSegment;
        this.tableName = tableName;
        this.operator = operator;
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.expressionSegment = expressionSegment;
        this.putPositionMap(0, expressionSegment);
    }

    private void putPositionMap(int index, ExpressionSegment expressionSegment) {
        if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
            this.positionIndexMap.put(index, ((ParameterMarkerExpressionSegment)expressionSegment).getParameterMarkerIndex());
        } else if (expressionSegment instanceof LiteralExpressionSegment) {
            this.positionValueMap.put(index, ((LiteralExpressionSegment)expressionSegment).getLiterals());
        } else if (expressionSegment instanceof FunctionSegment && "CONCAT".equalsIgnoreCase(((FunctionSegment)expressionSegment).getFunctionName())) {
            int parameterIndex = index;
            for (ExpressionSegment each : ((FunctionSegment)expressionSegment).getParameters()) {
                this.putPositionMap(parameterIndex++, each);
            }
        }
    }

    @Override
    @Generated
    public ColumnSegment getColumnSegment() {
        return this.columnSegment;
    }

    @Override
    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getOperator() {
        return this.operator;
    }

    @Override
    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Generated
    public ExpressionSegment getExpressionSegment() {
        return this.expressionSegment;
    }

    @Override
    @Generated
    public Map<Integer, Integer> getPositionIndexMap() {
        return this.positionIndexMap;
    }

    @Override
    @Generated
    public Map<Integer, Object> getPositionValueMap() {
        return this.positionValueMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptBinaryCondition)) {
            return false;
        }
        EncryptBinaryCondition other = (EncryptBinaryCondition)o;
        if (this.getStartIndex() != other.getStartIndex()) {
            return false;
        }
        if (this.getStopIndex() != other.getStopIndex()) {
            return false;
        }
        ColumnSegment this$columnSegment = this.getColumnSegment();
        ColumnSegment other$columnSegment = other.getColumnSegment();
        if (this$columnSegment == null ? other$columnSegment != null : !this$columnSegment.equals(other$columnSegment)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$operator = this.getOperator();
        String other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
            return false;
        }
        ExpressionSegment this$expressionSegment = this.getExpressionSegment();
        ExpressionSegment other$expressionSegment = other.getExpressionSegment();
        if (this$expressionSegment == null ? other$expressionSegment != null : !this$expressionSegment.equals(other$expressionSegment)) {
            return false;
        }
        Map<Integer, Integer> this$positionIndexMap = this.getPositionIndexMap();
        Map<Integer, Integer> other$positionIndexMap = other.getPositionIndexMap();
        if (this$positionIndexMap == null ? other$positionIndexMap != null : !((Object)this$positionIndexMap).equals(other$positionIndexMap)) {
            return false;
        }
        Map<Integer, Object> this$positionValueMap = this.getPositionValueMap();
        Map<Integer, Object> other$positionValueMap = other.getPositionValueMap();
        return !(this$positionValueMap == null ? other$positionValueMap != null : !((Object)this$positionValueMap).equals(other$positionValueMap));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStartIndex();
        result = result * 59 + this.getStopIndex();
        ColumnSegment $columnSegment = this.getColumnSegment();
        result = result * 59 + ($columnSegment == null ? 43 : $columnSegment.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        ExpressionSegment $expressionSegment = this.getExpressionSegment();
        result = result * 59 + ($expressionSegment == null ? 43 : $expressionSegment.hashCode());
        Map<Integer, Integer> $positionIndexMap = this.getPositionIndexMap();
        result = result * 59 + ($positionIndexMap == null ? 43 : ((Object)$positionIndexMap).hashCode());
        Map<Integer, Object> $positionValueMap = this.getPositionValueMap();
        result = result * 59 + ($positionValueMap == null ? 43 : ((Object)$positionValueMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EncryptBinaryCondition(columnSegment=" + this.getColumnSegment() + ", tableName=" + this.getTableName() + ", operator=" + this.getOperator() + ", startIndex=" + this.getStartIndex() + ", stopIndex=" + this.getStopIndex() + ", expressionSegment=" + this.getExpressionSegment() + ", positionIndexMap=" + this.getPositionIndexMap() + ", positionValueMap=" + this.getPositionValueMap() + ")";
    }
}

