/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import java.security.AlgorithmConstraints;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLParameters;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils_7;
import org.bouncycastle.jsse.provider.JsseUtils_8;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ReflectionUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class SSLParametersUtil {
    private static final Method getNamedGroups;
    private static final Method setNamedGroups;
    private static final Method getSignatureSchemes;
    private static final Method setSignatureSchemes;

    SSLParametersUtil() {
    }

    static BCSSLParameters getParameters(ProvSSLParameters provSSLParameters) {
        BCSSLParameters bCSSLParameters = new BCSSLParameters(provSSLParameters.getCipherSuites(), provSSLParameters.getProtocols());
        if (provSSLParameters.getNeedClientAuth()) {
            bCSSLParameters.setNeedClientAuth(true);
        } else {
            bCSSLParameters.setWantClientAuth(provSSLParameters.getWantClientAuth());
        }
        bCSSLParameters.setEndpointIdentificationAlgorithm(provSSLParameters.getEndpointIdentificationAlgorithm());
        bCSSLParameters.setAlgorithmConstraints(provSSLParameters.getAlgorithmConstraints());
        bCSSLParameters.setServerNames(provSSLParameters.getServerNames());
        bCSSLParameters.setSNIMatchers(provSSLParameters.getSNIMatchers());
        bCSSLParameters.setUseCipherSuitesOrder(provSSLParameters.getUseCipherSuitesOrder());
        bCSSLParameters.setApplicationProtocols(provSSLParameters.getApplicationProtocols());
        bCSSLParameters.setEnableRetransmissions(provSSLParameters.getEnableRetransmissions());
        bCSSLParameters.setMaximumPacketSize(provSSLParameters.getMaximumPacketSize());
        bCSSLParameters.setSignatureSchemes(provSSLParameters.getSignatureSchemes());
        bCSSLParameters.setNamedGroups(provSSLParameters.getNamedGroups());
        return bCSSLParameters;
    }

    static SSLParameters getSSLParameters(ProvSSLParameters provSSLParameters) {
        SSLParameters sSLParameters = new SSLParameters(provSSLParameters.getCipherSuites(), provSSLParameters.getProtocols());
        if (provSSLParameters.getNeedClientAuth()) {
            sSLParameters.setNeedClientAuth(true);
        } else {
            sSLParameters.setWantClientAuth(provSSLParameters.getWantClientAuth());
        }
        sSLParameters.setEndpointIdentificationAlgorithm(provSSLParameters.getEndpointIdentificationAlgorithm());
        sSLParameters.setAlgorithmConstraints(JsseUtils_7.exportAlgorithmConstraints(provSSLParameters.getAlgorithmConstraints()));
        String[] stringArray = provSSLParameters.getServerNames();
        if (null != stringArray) {
            sSLParameters.setServerNames(JsseUtils_8.exportSNIServerNames(stringArray));
        }
        if (null != (stringArray = provSSLParameters.getSNIMatchers())) {
            sSLParameters.setSNIMatchers(JsseUtils_8.exportSNIMatchers(stringArray));
        }
        sSLParameters.setUseCipherSuitesOrder(provSSLParameters.getUseCipherSuitesOrder());
        stringArray = provSSLParameters.getApplicationProtocols();
        if (null != stringArray) {
            sSLParameters.setApplicationProtocols(stringArray);
        }
        sSLParameters.setEnableRetransmissions(provSSLParameters.getEnableRetransmissions());
        sSLParameters.setMaximumPacketSize(provSSLParameters.getMaximumPacketSize());
        if (null != setSignatureSchemes) {
            SSLParametersUtil.set(sSLParameters, setSignatureSchemes, provSSLParameters.getSignatureSchemes());
        }
        if (null != setNamedGroups) {
            SSLParametersUtil.set(sSLParameters, setNamedGroups, provSSLParameters.getNamedGroups());
        }
        return sSLParameters;
    }

    static BCSSLParameters importSSLParameters(SSLParameters sSLParameters) {
        BCSSLParameters bCSSLParameters = new BCSSLParameters(sSLParameters.getCipherSuites(), sSLParameters.getProtocols());
        if (sSLParameters.getNeedClientAuth()) {
            bCSSLParameters.setNeedClientAuth(true);
        } else {
            bCSSLParameters.setWantClientAuth(sSLParameters.getWantClientAuth());
        }
        String[] stringArray = sSLParameters.getEndpointIdentificationAlgorithm();
        if (null != stringArray) {
            bCSSLParameters.setEndpointIdentificationAlgorithm((String)stringArray);
        }
        if (null != (stringArray = sSLParameters.getAlgorithmConstraints())) {
            bCSSLParameters.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraints((AlgorithmConstraints)stringArray));
        }
        if (null != (stringArray = sSLParameters.getServerNames())) {
            bCSSLParameters.setServerNames(JsseUtils_8.importSNIServerNames(stringArray));
        }
        if (null != (stringArray = sSLParameters.getSNIMatchers())) {
            bCSSLParameters.setSNIMatchers(JsseUtils_8.importSNIMatchers(stringArray));
        }
        bCSSLParameters.setUseCipherSuitesOrder(sSLParameters.getUseCipherSuitesOrder());
        stringArray = sSLParameters.getApplicationProtocols();
        if (null != stringArray) {
            bCSSLParameters.setApplicationProtocols(stringArray);
        }
        bCSSLParameters.setEnableRetransmissions(sSLParameters.getEnableRetransmissions());
        bCSSLParameters.setMaximumPacketSize(sSLParameters.getMaximumPacketSize());
        if (null != getSignatureSchemes) {
            bCSSLParameters.setSignatureSchemes((String[])SSLParametersUtil.get(sSLParameters, getSignatureSchemes));
        }
        if (null != getNamedGroups) {
            bCSSLParameters.setNamedGroups((String[])SSLParametersUtil.get(sSLParameters, getNamedGroups));
        }
        return bCSSLParameters;
    }

    static void setParameters(ProvSSLParameters provSSLParameters, BCSSLParameters bCSSLParameters) {
        Collection<BCSNIMatcher> collection;
        List<BCSNIServerName> list;
        BCAlgorithmConstraints bCAlgorithmConstraints;
        String[] stringArray;
        String[] stringArray2 = bCSSLParameters.getCipherSuites();
        if (null != stringArray2) {
            provSSLParameters.setCipherSuites(stringArray2);
        }
        if (null != (stringArray = bCSSLParameters.getProtocols())) {
            provSSLParameters.setProtocols(stringArray);
        }
        if (bCSSLParameters.getNeedClientAuth()) {
            provSSLParameters.setNeedClientAuth(true);
        } else {
            provSSLParameters.setWantClientAuth(bCSSLParameters.getWantClientAuth());
        }
        String string = bCSSLParameters.getEndpointIdentificationAlgorithm();
        if (null != string) {
            provSSLParameters.setEndpointIdentificationAlgorithm(string);
        }
        if (null != (bCAlgorithmConstraints = bCSSLParameters.getAlgorithmConstraints())) {
            provSSLParameters.setAlgorithmConstraints(bCAlgorithmConstraints);
        }
        if (null != (list = bCSSLParameters.getServerNames())) {
            provSSLParameters.setServerNames(list);
        }
        if (null != (collection = bCSSLParameters.getSNIMatchers())) {
            provSSLParameters.setSNIMatchers(collection);
        }
        provSSLParameters.setUseCipherSuitesOrder(bCSSLParameters.getUseCipherSuitesOrder());
        String[] stringArray3 = bCSSLParameters.getApplicationProtocols();
        if (null != stringArray3) {
            provSSLParameters.setApplicationProtocols(stringArray3);
        }
        provSSLParameters.setEnableRetransmissions(bCSSLParameters.getEnableRetransmissions());
        provSSLParameters.setMaximumPacketSize(bCSSLParameters.getMaximumPacketSize());
        provSSLParameters.setSignatureSchemes(bCSSLParameters.getSignatureSchemes());
        provSSLParameters.setNamedGroups(bCSSLParameters.getNamedGroups());
    }

    static void setSSLParameters(ProvSSLParameters provSSLParameters, SSLParameters sSLParameters) {
        String[] stringArray;
        String[] stringArray2 = sSLParameters.getCipherSuites();
        if (null != stringArray2) {
            provSSLParameters.setCipherSuites(stringArray2);
        }
        if (null != (stringArray = sSLParameters.getProtocols())) {
            provSSLParameters.setProtocols(stringArray);
        }
        if (sSLParameters.getNeedClientAuth()) {
            provSSLParameters.setNeedClientAuth(true);
        } else {
            provSSLParameters.setWantClientAuth(sSLParameters.getWantClientAuth());
        }
        String[] stringArray3 = sSLParameters.getEndpointIdentificationAlgorithm();
        if (null != stringArray3) {
            provSSLParameters.setEndpointIdentificationAlgorithm((String)stringArray3);
        }
        if (null != (stringArray3 = sSLParameters.getAlgorithmConstraints())) {
            provSSLParameters.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraints((AlgorithmConstraints)stringArray3));
        }
        if (null != (stringArray3 = sSLParameters.getServerNames())) {
            provSSLParameters.setServerNames(JsseUtils_8.importSNIServerNames(stringArray3));
        }
        if (null != (stringArray3 = sSLParameters.getSNIMatchers())) {
            provSSLParameters.setSNIMatchers(JsseUtils_8.importSNIMatchers(stringArray3));
        }
        provSSLParameters.setUseCipherSuitesOrder(sSLParameters.getUseCipherSuitesOrder());
        stringArray3 = sSLParameters.getApplicationProtocols();
        if (null != stringArray3) {
            provSSLParameters.setApplicationProtocols(stringArray3);
        }
        provSSLParameters.setEnableRetransmissions(sSLParameters.getEnableRetransmissions());
        provSSLParameters.setMaximumPacketSize(sSLParameters.getMaximumPacketSize());
        if (null != getSignatureSchemes) {
            provSSLParameters.setSignatureSchemes((String[])SSLParametersUtil.get(sSLParameters, getSignatureSchemes));
        }
        if (null != getNamedGroups) {
            provSSLParameters.setNamedGroups((String[])SSLParametersUtil.get(sSLParameters, getNamedGroups));
        }
    }

    private static Object get(Object object, Method method) {
        return ReflectionUtil.invokeGetter(object, method);
    }

    private static void set(Object object, Method method, Object object2) {
        ReflectionUtil.invokeSetter(object, method, object2);
    }

    static {
        Method[] methodArray = ReflectionUtil.getMethods("javax.net.ssl.SSLParameters");
        getNamedGroups = ReflectionUtil.findMethod(methodArray, "getNamedGroups");
        setNamedGroups = ReflectionUtil.findMethod(methodArray, "setNamedGroups");
        getSignatureSchemes = ReflectionUtil.findMethod(methodArray, "getSignatureSchemes");
        setSignatureSchemes = ReflectionUtil.findMethod(methodArray, "setSignatureSchemes");
    }
}

