/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.text.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.shardingsphere.driver.executor.engine.batch.preparedstatement.BatchExecutionUnit;
import org.apache.shardingsphere.driver.executor.engine.batch.preparedstatement.BatchPreparedStatementExecutor;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.audit.SQLAuditEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.MultiStatementsUpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;

public final class MySQLMultiStatementsHandler
implements ProxyBackendHandler {
    private static final Pattern MULTI_INSERT_STATEMENTS = Pattern.compile(";(?=\\s*insert)", 2);
    private static final Pattern MULTI_UPDATE_STATEMENTS = Pattern.compile(";(?=\\s*update)", 2);
    private static final Pattern MULTI_DELETE_STATEMENTS = Pattern.compile(";(?=\\s*delete)", 2);
    private final MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
    private final Collection<QueryContext> multiSQLQueryContexts = new LinkedList<QueryContext>();
    private final ConnectionSession connectionSession;
    private final SQLStatement sqlStatementSample;
    private final BatchPreparedStatementExecutor batchExecutor;

    public MySQLMultiStatementsHandler(ConnectionSession connectionSession, SQLStatement sqlStatementSample, String sql) {
        connectionSession.getDatabaseConnectionManager().handleAutoCommit();
        this.connectionSession = connectionSession;
        this.sqlStatementSample = sqlStatementSample;
        JDBCExecutor jdbcExecutor = new JDBCExecutor(BackendExecutorContext.getInstance().getExecutorEngine(), connectionSession.getConnectionContext());
        this.batchExecutor = new BatchPreparedStatementExecutor(this.metaDataContexts.getMetaData().getDatabase(connectionSession.getUsedDatabaseName()), jdbcExecutor, connectionSession.getProcessId());
        Pattern pattern = this.getPattern(sqlStatementSample);
        SQLParserEngine sqlParserEngine = this.getSQLParserEngine();
        for (String each : this.extractMultiStatements(pattern, sql)) {
            SQLStatement eachSQLStatement = sqlParserEngine.parse(each, false);
            this.multiSQLQueryContexts.add(this.createQueryContext(each, eachSQLStatement));
        }
    }

    private Pattern getPattern(SQLStatement sqlStatementSample) {
        if (sqlStatementSample instanceof InsertStatement) {
            return MULTI_INSERT_STATEMENTS;
        }
        return sqlStatementSample instanceof UpdateStatement ? MULTI_UPDATE_STATEMENTS : MULTI_DELETE_STATEMENTS;
    }

    private SQLParserEngine getSQLParserEngine() {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        SQLParserRule sqlParserRule = (SQLParserRule)metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        return sqlParserRule.getSQLParserEngine((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"MySQL"));
    }

    private List<String> extractMultiStatements(Pattern pattern, String sql) {
        return Arrays.asList(pattern.split(sql));
    }

    private QueryContext createQueryContext(String sql, SQLStatement sqlStatement) {
        HintValueContext hintValueContext = SQLHintUtils.extractHint((String)sql);
        SQLStatementContext sqlStatementContext = new SQLBindEngine(this.metaDataContexts.getMetaData(), this.connectionSession.getCurrentDatabaseName(), hintValueContext).bind(sqlStatement, Collections.emptyList());
        return new QueryContext(sqlStatementContext, sql, Collections.emptyList(), hintValueContext, this.connectionSession.getConnectionContext(), this.metaDataContexts.getMetaData());
    }

    public ResponseHeader execute() throws SQLException {
        Collection rules = this.metaDataContexts.getMetaData().getDatabase(this.connectionSession.getUsedDatabaseName()).getRuleMetaData().getRules();
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        DriverExecutionPrepareEngine prepareEngine = new DriverExecutionPrepareEngine("JDBC.STATEMENT", maxConnectionsSizePerQuery, (DatabaseConnectionManager)this.connectionSession.getDatabaseConnectionManager(), (ExecutorStatementManager)((JDBCBackendStatement)this.connectionSession.getStatementManager()), (StorageResourceOption)new StatementOption(false), rules, this.metaDataContexts.getMetaData().getDatabase(this.connectionSession.getUsedDatabaseName()).getResourceMetaData().getStorageUnits());
        return this.executeMultiStatements((DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection>)prepareEngine);
    }

    private ResponseHeader executeMultiStatements(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine) throws SQLException {
        Collection<ExecutionContext> executionContexts = this.createExecutionContexts();
        ExecutionGroupContext executionGroupContext = prepareEngine.prepare(this.connectionSession.getUsedDatabaseName(), executionContexts.iterator().next().getRouteContext(), this.createExecutionUnits(), new ExecutionGroupReportContext(this.connectionSession.getProcessId(), this.connectionSession.getUsedDatabaseName(), this.connectionSession.getConnectionContext().getGrantee()));
        this.batchExecutor.init(executionGroupContext);
        this.executeAddBatch((ExecutionGroupContext<JDBCExecutionUnit>)executionGroupContext);
        return new MultiStatementsUpdateResponseHeader(this.buildUpdateResponseHeaders(this.batchExecutor.executeBatch(this.multiSQLQueryContexts.iterator().next().getSqlStatementContext())));
    }

    private List<ExecutionUnit> createExecutionUnits() {
        ArrayList<ExecutionUnit> result = new ArrayList<ExecutionUnit>(this.batchExecutor.getBatchExecutionUnits().size());
        for (BatchExecutionUnit each : this.batchExecutor.getBatchExecutionUnits()) {
            ExecutionUnit executionUnit = each.getExecutionUnit();
            result.add(executionUnit);
        }
        return result;
    }

    private Collection<ExecutionContext> createExecutionContexts() {
        LinkedList<ExecutionContext> result = new LinkedList<ExecutionContext>();
        for (QueryContext each : this.multiSQLQueryContexts) {
            ExecutionContext executionContext = this.createExecutionContext(each);
            this.batchExecutor.addBatchForExecutionUnits(executionContext.getExecutionUnits());
            result.add(executionContext);
        }
        return result;
    }

    private ExecutionContext createExecutionContext(QueryContext queryContext) {
        RuleMetaData globalRuleMetaData = this.metaDataContexts.getMetaData().getGlobalRuleMetaData();
        ShardingSphereDatabase currentDatabase = this.metaDataContexts.getMetaData().getDatabase(this.connectionSession.getCurrentDatabaseName());
        SQLAuditEngine.audit((QueryContext)queryContext, (RuleMetaData)globalRuleMetaData, (ShardingSphereDatabase)currentDatabase);
        return new KernelProcessor().generateExecutionContext(queryContext, globalRuleMetaData, this.metaDataContexts.getMetaData().getProps());
    }

    private void executeAddBatch(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext) throws SQLException {
        for (ExecutionGroup each : executionGroupContext.getInputGroups()) {
            for (JDBCExecutionUnit unit : each.getInputs()) {
                unit.getStorageResource().addBatch(unit.getExecutionUnit().getSqlUnit().getSql());
            }
        }
    }

    private Collection<UpdateResponseHeader> buildUpdateResponseHeaders(int[] updateCounts) {
        LinkedList<UpdateResponseHeader> result = new LinkedList<UpdateResponseHeader>();
        for (int each : updateCounts) {
            result.add(new UpdateResponseHeader(this.sqlStatementSample, Collections.singletonList(new UpdateResult(each, 0L))));
        }
        return result;
    }
}

