/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.mapper.ApiMapper;
import org.apache.shenyu.admin.model.dto.ApiDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.ApiQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.ApiVO;
import org.apache.shenyu.admin.service.ApiService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@RestApi(value={"/api"})
public class ApiController {
    private final ApiService apiService;

    public ApiController(ApiService apiService) {
        this.apiService = apiService;
    }

    @GetMapping
    public ShenyuAdminResult queryApis(String apiPath, Integer state, String tagId, @NotNull Integer currentPage, @NotNull Integer pageSize) {
        CommonPager<ApiVO> commonPager = this.apiService.listByPage(new ApiQuery(apiPath, state, tagId, new PageParameter(currentPage, pageSize)));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/{id}"})
    public ShenyuAdminResult detailApi(@PathVariable(value="id") @Existed(message="api is not existed", provider=ApiMapper.class) @Existed(message="api is not existed", provider=ApiMapper.class) String id) {
        ApiVO apiVO = this.apiService.findById(id);
        return ShenyuAdminResult.success("detail success", apiVO);
    }

    @PostMapping
    @RequiresPermissions(value={"system:api:add"})
    public ShenyuAdminResult createApi(@Valid @RequestBody ApiDTO apiDTO) {
        return ShenyuAdminResult.success(this.apiService.createOrUpdate(apiDTO));
    }

    @PutMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:api:edit"})
    public ShenyuAdminResult updateApi(@PathVariable(value="id") @Existed(message="api is not existed", provider=ApiMapper.class) @Existed(message="api is not existed", provider=ApiMapper.class) String id, @Valid @RequestBody ApiDTO apiDTO) {
        apiDTO.setId(id);
        return ShenyuAdminResult.success(this.apiService.createOrUpdate(apiDTO));
    }

    @DeleteMapping(value={"/batch"})
    @RequiresPermissions(value={"system:api:delete"})
    public ShenyuAdminResult deleteApis(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        String result = this.apiService.delete(ids);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("delete success");
    }
}

