/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.PollListener;
import com.netflix.config.PollResult;
import com.netflix.config.PolledConfigurationSource;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPollingScheduler {
    private volatile boolean ignoreDeletesFromSource;
    private List<PollListener> listeners = new CopyOnWriteArrayList<PollListener>();
    private volatile Object checkPoint;
    private static Logger log = LoggerFactory.getLogger(AbstractPollingScheduler.class);

    public AbstractPollingScheduler(boolean bl) {
        this.ignoreDeletesFromSource = bl;
    }

    public AbstractPollingScheduler() {
        this.ignoreDeletesFromSource = false;
    }

    protected synchronized void initialLoad(PolledConfigurationSource polledConfigurationSource, Configuration configuration) {
        PollResult pollResult = null;
        try {
            pollResult = polledConfigurationSource.poll(true, null);
            this.checkPoint = pollResult.getCheckPoint();
            this.fireEvent(PollListener.EventType.POLL_SUCCESS, pollResult, null);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to load Properties source from " + polledConfigurationSource, throwable);
        }
        try {
            this.populateProperties(pollResult, configuration);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to load Properties", throwable);
        }
    }

    protected void populateProperties(PollResult pollResult, Configuration configuration) {
        block12: {
            block11: {
                if (pollResult == null || !pollResult.hasChanges()) {
                    return;
                }
                if (pollResult.isIncremental()) break block11;
                Map<String, Object> map = pollResult.getComplete();
                if (map == null) {
                    return;
                }
                for (Map.Entry<String, Object> iterator2 : map.entrySet()) {
                    this.addOrChangeProperty(iterator2.getKey(), iterator2.getValue(), configuration);
                }
                HashSet hashSet = new HashSet();
                Iterator object = configuration.getKeys();
                while (object.hasNext()) {
                    hashSet.add(object.next());
                }
                if (this.ignoreDeletesFromSource) break block12;
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (map.containsKey(string)) continue;
                    this.deleteProperty(string, configuration);
                }
                break block12;
            }
            Map<String, Object> map = pollResult.getAdded();
            if (map != null) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    this.addOrChangeProperty(entry.getKey(), entry.getValue(), configuration);
                }
            }
            if ((map = pollResult.getChanged()) != null) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    this.addOrChangeProperty(entry.getKey(), entry.getValue(), configuration);
                }
            }
            if (!this.ignoreDeletesFromSource && (map = pollResult.getDeleted()) != null) {
                for (String string : map.keySet()) {
                    this.deleteProperty(string, configuration);
                }
            }
        }
    }

    private void addOrChangeProperty(String string, Object object, Configuration configuration) {
        if (!configuration.containsKey(string)) {
            configuration.addProperty(string, object);
        } else {
            Object object2 = configuration.getProperty(string);
            if (object != null) {
                if (!object.equals(object2)) {
                    configuration.setProperty(string, object);
                }
            } else if (object2 != null) {
                configuration.setProperty(string, null);
            }
        }
    }

    private void deleteProperty(String string, Configuration configuration) {
        if (configuration.containsKey(string)) {
            configuration.clearProperty(string);
        }
    }

    protected Runnable getPollingRunnable(final PolledConfigurationSource polledConfigurationSource, final Configuration configuration) {
        return new Runnable(){

            @Override
            public void run() {
                log.debug("Polling started");
                PollResult pollResult = null;
                try {
                    pollResult = polledConfigurationSource.poll(false, AbstractPollingScheduler.this.getNextCheckPoint(AbstractPollingScheduler.this.checkPoint));
                    AbstractPollingScheduler.this.checkPoint = pollResult.getCheckPoint();
                    AbstractPollingScheduler.this.fireEvent(PollListener.EventType.POLL_SUCCESS, pollResult, null);
                }
                catch (Throwable throwable) {
                    log.error("Error getting result from polling source", throwable);
                    AbstractPollingScheduler.this.fireEvent(PollListener.EventType.POLL_FAILURE, null, throwable);
                    return;
                }
                try {
                    AbstractPollingScheduler.this.populateProperties(pollResult, configuration);
                }
                catch (Throwable throwable) {
                    log.error("Error occured applying properties", throwable);
                }
            }
        };
    }

    private void fireEvent(PollListener.EventType eventType, PollResult pollResult, Throwable throwable) {
        for (PollListener pollListener : this.listeners) {
            try {
                pollListener.handleEvent(eventType, pollResult, throwable);
            }
            catch (Throwable throwable2) {
                log.error("Error in invoking listener", throwable2);
            }
        }
    }

    public void startPolling(PolledConfigurationSource polledConfigurationSource, Configuration configuration) {
        this.initialLoad(polledConfigurationSource, configuration);
        Runnable runnable = this.getPollingRunnable(polledConfigurationSource, configuration);
        this.schedule(runnable);
    }

    public void addPollListener(PollListener pollListener) {
        if (pollListener != null) {
            this.listeners.add(pollListener);
        }
    }

    public void removePollListener(PollListener pollListener) {
        if (pollListener != null) {
            this.listeners.remove(pollListener);
        }
    }

    protected Object getNextCheckPoint(Object object) {
        return object;
    }

    protected abstract void schedule(Runnable var1);

    public abstract void stop();

    public final boolean isIgnoreDeletesFromSource() {
        return this.ignoreDeletesFromSource;
    }

    public final void setIgnoreDeletesFromSource(boolean bl) {
        this.ignoreDeletesFromSource = bl;
    }
}

