/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.common;

import com.alipay.sofa.common.config.SofaConfigs;
import com.alipay.sofa.rpc.common.config.RpcConfigKeys;
import com.alipay.sofa.rpc.common.utils.IOUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class BlackAndWhiteListFileLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlackAndWhiteListFileLoader.class);
    public static final List<String> SOFA_SERIALIZE_BLACK_LIST = BlackAndWhiteListFileLoader.loadBlackListFile("/sofa-rpc/serialize_blacklist.txt");
    public static final List<String> SOFA_SERIALIZER_WHITE_LIST = BlackAndWhiteListFileLoader.loadWhiteListFile("/sofa-rpc/serialize_whitelist.txt");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadBlackListFile(String path) {
        ArrayList<String> blackPrefixList = new ArrayList<String>();
        InputStream input = null;
        try {
            String overStr;
            input = BlackAndWhiteListFileLoader.class.getResourceAsStream(path);
            if (input != null) {
                BlackAndWhiteListFileLoader.readToList(input, "UTF-8", blackPrefixList);
            }
            if (StringUtils.isNotBlank(overStr = (String)SofaConfigs.getOrCustomDefault(RpcConfigKeys.SERIALIZE_BLACKLIST_OVERRIDE, (Object)""))) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Serialize blacklist will override with configuration: {}", overStr);
                }
                BlackAndWhiteListFileLoader.overrideBlackList(blackPrefixList, overStr);
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        finally {
            IOUtils.closeQuietly(input);
        }
        return blackPrefixList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadWhiteListFile(String path) {
        ArrayList<String> whitePrefixList = new ArrayList<String>();
        InputStream input = null;
        try {
            String overStr;
            input = BlackAndWhiteListFileLoader.class.getResourceAsStream(path);
            if (input != null) {
                BlackAndWhiteListFileLoader.readToList(input, "UTF-8", whitePrefixList);
            }
            if (StringUtils.isNotBlank(overStr = (String)SofaConfigs.getOrCustomDefault(RpcConfigKeys.SERIALIZE_WHITELIST_OVERRIDE, (Object)""))) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Serialize whitelist will override with configuration: {}", overStr);
                }
                BlackAndWhiteListFileLoader.overrideWhiteList(whitePrefixList, overStr);
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        finally {
            IOUtils.closeQuietly(input);
        }
        return whitePrefixList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readToList(InputStream input, String encoding, List<String> blackPrefixList) {
        block7: {
            InputStreamReader reader = null;
            BufferedReader bufferedReader = null;
            try {
                String lineText;
                reader = new InputStreamReader(input, encoding);
                bufferedReader = new BufferedReader(reader);
                while ((lineText = bufferedReader.readLine()) != null) {
                    String pkg = lineText.trim();
                    if (pkg.length() <= 0) continue;
                    blackPrefixList.add(pkg);
                }
                IOUtils.closeQuietly(bufferedReader);
            }
            catch (IOException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(e.getMessage(), e);
                }
                break block7;
            }
            finally {
                IOUtils.closeQuietly(bufferedReader);
                IOUtils.closeQuietly(reader);
            }
            IOUtils.closeQuietly(reader);
        }
    }

    public static void overrideBlackList(List<String> originList, String overrideStr) {
        String[] overrideItems;
        LinkedList<String> adds = new LinkedList<String>();
        for (String overrideItem : overrideItems = StringUtils.splitWithCommaOrSemicolon(overrideStr)) {
            if (!StringUtils.isNotBlank(overrideItem)) continue;
            if (overrideItem.startsWith("!") || overrideItem.startsWith("-")) {
                if ("*".equals(overrideItem = overrideItem.substring(1)) || "default".equals(overrideItem)) {
                    originList.clear();
                    continue;
                }
                originList.remove(overrideItem);
                continue;
            }
            if (originList.contains(overrideItem)) continue;
            adds.add(overrideItem);
        }
        if (adds.size() > 0) {
            originList.addAll(adds);
        }
    }

    public static void overrideWhiteList(List<String> originList, String overrideStr) {
        String[] overrideItems;
        LinkedList<String> adds = new LinkedList<String>();
        for (String overrideItem : overrideItems = StringUtils.splitWithCommaOrSemicolon(overrideStr)) {
            if (!StringUtils.isNotBlank(overrideItem) || originList.contains(overrideItem)) continue;
            adds.add(overrideItem);
        }
        if (adds.size() > 0) {
            originList.addAll(adds);
        }
    }
}

