/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client.transport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.client.transport.FlowSseClient;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class HttpClientSseClientTransport
implements McpClientTransport {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientSseClientTransport.class);
    private static final String MESSAGE_EVENT_TYPE = "message";
    private static final String ENDPOINT_EVENT_TYPE = "endpoint";
    private static final String DEFAULT_SSE_ENDPOINT = "/sse";
    private final URI baseUri;
    private final String sseEndpoint;
    private final FlowSseClient sseClient;
    private final HttpClient httpClient;
    private final HttpRequest.Builder requestBuilder;
    protected ObjectMapper objectMapper;
    private volatile boolean isClosing = false;
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private final AtomicReference<String> messageEndpoint = new AtomicReference();
    private final AtomicReference<CompletableFuture<Void>> connectionFuture = new AtomicReference();

    @Deprecated(forRemoval=true)
    public HttpClientSseClientTransport(String baseUri) {
        this(HttpClient.newBuilder(), baseUri, new ObjectMapper());
    }

    @Deprecated(forRemoval=true)
    public HttpClientSseClientTransport(HttpClient.Builder clientBuilder, String baseUri, ObjectMapper objectMapper) {
        this(clientBuilder, baseUri, DEFAULT_SSE_ENDPOINT, objectMapper);
    }

    @Deprecated(forRemoval=true)
    public HttpClientSseClientTransport(HttpClient.Builder clientBuilder, String baseUri, String sseEndpoint, ObjectMapper objectMapper) {
        this(clientBuilder, HttpRequest.newBuilder(), baseUri, sseEndpoint, objectMapper);
    }

    @Deprecated(forRemoval=true)
    public HttpClientSseClientTransport(HttpClient.Builder clientBuilder, HttpRequest.Builder requestBuilder, String baseUri, String sseEndpoint, ObjectMapper objectMapper) {
        this(clientBuilder.connectTimeout(Duration.ofSeconds(10L)).build(), requestBuilder, baseUri, sseEndpoint, objectMapper);
    }

    HttpClientSseClientTransport(HttpClient httpClient, HttpRequest.Builder requestBuilder, String baseUri, String sseEndpoint, ObjectMapper objectMapper) {
        Assert.notNull(objectMapper, "ObjectMapper must not be null");
        Assert.hasText(baseUri, "baseUri must not be empty");
        Assert.hasText(sseEndpoint, "sseEndpoint must not be empty");
        Assert.notNull(httpClient, "httpClient must not be null");
        Assert.notNull(requestBuilder, "requestBuilder must not be null");
        this.baseUri = URI.create(baseUri);
        this.sseEndpoint = sseEndpoint;
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
        this.requestBuilder = requestBuilder;
        this.sseClient = new FlowSseClient(this.httpClient, requestBuilder);
    }

    public static Builder builder(String baseUri) {
        return new Builder().baseUri(baseUri);
    }

    @Override
    public Mono<Void> connect(final Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> handler) {
        final CompletableFuture future = new CompletableFuture();
        this.connectionFuture.set(future);
        URI clientUri = Utils.resolveUri(this.baseUri, this.sseEndpoint);
        this.sseClient.subscribe(clientUri.toString(), new FlowSseClient.SseEventHandler(){

            @Override
            public void onEvent(FlowSseClient.SseEvent event) {
                if (HttpClientSseClientTransport.this.isClosing) {
                    return;
                }
                try {
                    if (HttpClientSseClientTransport.ENDPOINT_EVENT_TYPE.equals(event.type())) {
                        String endpoint = event.data();
                        HttpClientSseClientTransport.this.messageEndpoint.set(endpoint);
                        HttpClientSseClientTransport.this.closeLatch.countDown();
                        future.complete(null);
                    } else if (HttpClientSseClientTransport.MESSAGE_EVENT_TYPE.equals(event.type())) {
                        McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage(HttpClientSseClientTransport.this.objectMapper, event.data());
                        ((Mono)handler.apply(Mono.just((Object)message))).subscribe();
                    } else {
                        logger.error("Received unrecognized SSE event type: {}", (Object)event.type());
                    }
                }
                catch (IOException e) {
                    logger.error("Error processing SSE event", (Throwable)e);
                    future.completeExceptionally(e);
                }
            }

            @Override
            public void onError(Throwable error) {
                if (!HttpClientSseClientTransport.this.isClosing) {
                    logger.error("SSE connection error", error);
                    future.completeExceptionally(error);
                }
            }
        });
        return Mono.fromFuture(future);
    }

    @Override
    public Mono<Void> sendMessage(McpSchema.JSONRPCMessage message) {
        if (this.isClosing) {
            return Mono.empty();
        }
        try {
            if (!this.closeLatch.await(10L, TimeUnit.SECONDS)) {
                return Mono.error((Throwable)new McpError((Object)"Failed to wait for the message endpoint"));
            }
        }
        catch (InterruptedException e) {
            return Mono.error((Throwable)new McpError((Object)"Failed to wait for the message endpoint"));
        }
        String endpoint = this.messageEndpoint.get();
        if (endpoint == null) {
            return Mono.error((Throwable)new McpError((Object)"No message endpoint available"));
        }
        try {
            String jsonText = this.objectMapper.writeValueAsString((Object)message);
            URI requestUri = Utils.resolveUri(this.baseUri, endpoint);
            HttpRequest request = this.requestBuilder.uri(requestUri).POST(HttpRequest.BodyPublishers.ofString(jsonText)).build();
            return Mono.fromFuture((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.discarding()).thenAccept(response -> {
                if (response.statusCode() != 200 && response.statusCode() != 201 && response.statusCode() != 202 && response.statusCode() != 206) {
                    logger.error("Error sending message: {}", (Object)response.statusCode());
                }
            }));
        }
        catch (IOException e) {
            if (!this.isClosing) {
                return Mono.error((Throwable)new RuntimeException("Failed to serialize message", e));
            }
            return Mono.empty();
        }
    }

    @Override
    public Mono<Void> closeGracefully() {
        return Mono.fromRunnable(() -> {
            this.isClosing = true;
            CompletableFuture<Void> future = this.connectionFuture.get();
            if (future != null && !future.isDone()) {
                future.cancel(true);
            }
        });
    }

    @Override
    public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
        return (T)this.objectMapper.convertValue(data, typeRef);
    }

    public static class Builder {
        private String baseUri;
        private String sseEndpoint = "/sse";
        private HttpClient.Builder clientBuilder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(10L));
        private ObjectMapper objectMapper = new ObjectMapper();
        private HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().header("Content-Type", "application/json");

        Builder() {
        }

        @Deprecated(forRemoval=true)
        public Builder(String baseUri) {
            Assert.hasText(baseUri, "baseUri must not be empty");
            this.baseUri = baseUri;
        }

        Builder baseUri(String baseUri) {
            Assert.hasText(baseUri, "baseUri must not be empty");
            this.baseUri = baseUri;
            return this;
        }

        public Builder sseEndpoint(String sseEndpoint) {
            Assert.hasText(sseEndpoint, "sseEndpoint must not be empty");
            this.sseEndpoint = sseEndpoint;
            return this;
        }

        public Builder clientBuilder(HttpClient.Builder clientBuilder) {
            Assert.notNull(clientBuilder, "clientBuilder must not be null");
            this.clientBuilder = clientBuilder;
            return this;
        }

        public Builder customizeClient(Consumer<HttpClient.Builder> clientCustomizer) {
            Assert.notNull(clientCustomizer, "clientCustomizer must not be null");
            clientCustomizer.accept(this.clientBuilder);
            return this;
        }

        public Builder requestBuilder(HttpRequest.Builder requestBuilder) {
            Assert.notNull(requestBuilder, "requestBuilder must not be null");
            this.requestBuilder = requestBuilder;
            return this;
        }

        public Builder customizeRequest(Consumer<HttpRequest.Builder> requestCustomizer) {
            Assert.notNull(requestCustomizer, "requestCustomizer must not be null");
            requestCustomizer.accept(this.requestBuilder);
            return this;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            Assert.notNull(objectMapper, "objectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public HttpClientSseClientTransport build() {
            return new HttpClientSseClientTransport(this.clientBuilder.build(), this.requestBuilder, this.baseUri, this.sseEndpoint, this.objectMapper);
        }
    }
}

