/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze;

import com.weibo.breeze.BreezeException;
import com.weibo.breeze.message.Schema;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SchemaUtil {
    private static Pattern fieldPattern = Pattern.compile("^([\\w<>., ]+) +(\\w+) *= *(\\d+) *;$");

    public static Schema parseSchema(String content) throws BreezeException {
        try {
            Schema schema = new Schema();
            BufferedReader reader = new BufferedReader(new StringReader(content));
            String packageString = null;
            boolean inMessage = false;
            boolean inEnum = false;
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    throw new BreezeException("unexpected end with schema");
                }
                if ((line = line.trim()).startsWith("message ")) {
                    schema.setName(packageString + "." + SchemaUtil.getName(line, 8));
                    inMessage = true;
                    continue;
                }
                if (inMessage) {
                    if (line.equals("{")) continue;
                    if (line.startsWith("}")) {
                        return schema;
                    }
                    Matcher matcher = fieldPattern.matcher(line);
                    if (!matcher.find()) {
                        throw new BreezeException("wrong field format. line:" + line);
                    }
                    schema.putField(Integer.parseInt(matcher.group(3)), matcher.group(2).trim(), matcher.group(1).trim());
                    continue;
                }
                if (line.startsWith("package ")) {
                    if (packageString != null) continue;
                    packageString = line.substring(8, line.length() - 1).trim();
                    continue;
                }
                if (line.startsWith("option java_package")) {
                    packageString = line.substring(line.indexOf("=") + 1, line.length() - 1).trim();
                    continue;
                }
                if (line.startsWith("option java_name")) {
                    schema.setJavaName(line.substring(line.indexOf("=") + 1, line.length() - 1).trim());
                    continue;
                }
                if (line.startsWith("enum ")) {
                    schema.setName(packageString + "." + SchemaUtil.getName(line, 5));
                    inEnum = true;
                    schema.setEnum(true);
                    continue;
                }
                if (!inEnum || line.equals("{")) continue;
                if (line.startsWith("}")) {
                    return schema;
                }
                String[] strings = line.split("=");
                if (strings.length != 2) {
                    throw new BreezeException("wrong enum format. line:" + line);
                }
                schema.addEnumValue(Integer.parseInt(strings[1].substring(0, strings[1].length() - 1).trim()), strings[0].trim());
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String getName(String line, int startPos) {
        int index = line.indexOf("(");
        if (index < 0) {
            index = line.indexOf("{");
        }
        if (index < 0) {
            index = line.length();
        }
        return line.substring(startPos, index).trim();
    }

    public static String toFileContent(Schema schema) {
        String packageName = schema.getName();
        int index = schema.getName().lastIndexOf(".");
        if (index > -1) {
            packageName = schema.getName().substring(0, index);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("option java_package = ").append(packageName).append(";\n");
        if (schema.getJavaName() != null) {
            sb.append("option java_name = ").append(schema.getJavaName()).append(";\n");
        }
        sb.append("\npackage ").append(packageName).append(";\n\n");
        if (schema.isEnum()) {
            sb.append("enum ").append(schema.getName().substring(index + 1)).append("{\n");
            for (Map.Entry<Integer, String> entry : schema.getEnumValues().entrySet()) {
                sb.append("    ").append((Object)entry.getValue()).append(" = ").append(entry.getKey()).append(";\n");
            }
            sb.append("}\n");
        } else {
            sb.append("message ").append(schema.getName().substring(index + 1)).append("{\n");
            ArrayList<Integer> fields = new ArrayList<Integer>(schema.getFields().keySet());
            Collections.sort(fields);
            for (Integer fieldIndex : fields) {
                Schema.Field field = schema.getFieldByIndex(fieldIndex);
                sb.append("    ").append(field.getType()).append(" ").append(field.getName()).append(" = ").append(field.getIndex()).append(";\n");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

