/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.resolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.SharedResourceHolder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.convert.selector.GrpcUpstream;
import org.apache.shenyu.plugin.grpc.cache.ApplicationConfigCache;
import org.apache.shenyu.plugin.grpc.loadbalance.GrpcAttributeUtils;
import org.apache.shenyu.plugin.grpc.resolver.ShenyuResolverHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShenyuNameResolver
extends NameResolver
implements Consumer<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuNameResolver.class);
    private boolean resolving;
    private NameResolver.Listener2 listener;
    private Executor executor;
    private final String appName;
    private final Attributes attributes;
    private final SynchronizationContext syncContext;
    private List<GrpcUpstream> instanceList = Lists.newArrayList();
    private final SharedResourceHolder.Resource<Executor> executorResource;

    public ShenyuNameResolver(String appName, NameResolver.Args args, SharedResourceHolder.Resource<Executor> executorResource) {
        this.appName = appName;
        this.executor = args.getOffloadExecutor();
        this.executorResource = executorResource;
        this.attributes = Attributes.newBuilder().set(GrpcAttributeUtils.APP_NAME, (Object)appName).build();
        this.syncContext = Objects.requireNonNull(args.getSynchronizationContext(), "syncContext");
    }

    public void start(NameResolver.Listener2 listener) {
        Preconditions.checkState((boolean)Objects.isNull(this.listener), (Object)"already started");
        this.executor = (Executor)SharedResourceHolder.get(this.executorResource);
        this.listener = (NameResolver.Listener2)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        ApplicationConfigCache.getInstance().watch(this.appName, this);
        this.resolve();
    }

    @Override
    public void accept(Object o) {
        this.syncContext.execute(() -> {
            if (Objects.nonNull(this.listener)) {
                this.resolve();
            }
        });
    }

    public void refresh() {
        Preconditions.checkState((boolean)Objects.nonNull(this.listener), (Object)"not started");
        this.resolve();
    }

    private void resolve() {
        LOG.info("Scheduled resolve for {}", (Object)this.appName);
        if (this.resolving) {
            return;
        }
        this.resolving = true;
        this.executor.execute(new Resolve(this.listener, this.instanceList));
    }

    public String getServiceAuthority() {
        return this.appName;
    }

    public void shutdown() {
        this.listener = null;
        if (Objects.nonNull(this.executor)) {
            this.executor = (Executor)SharedResourceHolder.release(this.executorResource, (Object)this.executor);
        }
        this.instanceList = Lists.newArrayList();
    }

    private final class Resolve
    implements Runnable {
        private final NameResolver.Listener2 savedListener;
        private final List<GrpcUpstream> savedInstanceList;

        Resolve(NameResolver.Listener2 listener, List<GrpcUpstream> instanceList) {
            this.savedListener = Objects.requireNonNull(listener, "listener");
            this.savedInstanceList = Objects.requireNonNull(instanceList, "instanceList");
        }

        @Override
        public void run() {
            AtomicReference<List<GrpcUpstream>> resultContainer = new AtomicReference<List<GrpcUpstream>>();
            try {
                resultContainer.set(this.resolveInternal());
            }
            catch (Exception e) {
                this.savedListener.onError(Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed to update server list for " + ShenyuNameResolver.this.appName));
                resultContainer.set(Lists.newArrayList());
            }
            finally {
                ShenyuNameResolver.this.syncContext.execute(() -> {
                    ShenyuNameResolver.this.resolving = false;
                    List newInstanceList = (List)resultContainer.get();
                    if (Objects.nonNull(newInstanceList) && Objects.nonNull(ShenyuNameResolver.this.listener)) {
                        ShenyuNameResolver.this.instanceList = newInstanceList;
                    }
                });
            }
        }

        private List<GrpcUpstream> resolveInternal() {
            String name = ShenyuNameResolver.this.appName;
            List<GrpcUpstream> grpcUpstreamList = Optional.ofNullable(ApplicationConfigCache.getInstance().getGrpcUpstreamListCache(name)).orElse(Collections.emptyList());
            LOG.info("Got {} candidate servers for {}", (Object)grpcUpstreamList.size(), (Object)name);
            if (CollectionUtils.isEmpty(grpcUpstreamList)) {
                LOG.info("No servers found for {}", (Object)name);
                this.savedListener.onError(Status.UNAVAILABLE.withDescription("No servers found for " + name));
                return Lists.newArrayList();
            }
            if (!this.needsToUpdateConnections(grpcUpstreamList)) {
                LOG.info("Nothing has changed... skipping update for {}", (Object)name);
                return Collections.emptyList();
            }
            LOG.info("Ready to update server list for {}", (Object)name);
            List targets = grpcUpstreamList.stream().map(instance -> {
                LOG.info("Found gRPC server {} for {}", (Object)instance.getUpstreamUrl(), (Object)name);
                return ShenyuResolverHelper.convertToEquivalentAddressGroup(instance);
            }).collect(Collectors.toList());
            this.savedListener.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses(targets).setAttributes(ShenyuNameResolver.this.attributes).build());
            LOG.info("Done updating server list for {}", (Object)name);
            return grpcUpstreamList;
        }

        private boolean needsToUpdateConnections(List<GrpcUpstream> newInstanceList) {
            if (!Objects.equals(this.savedInstanceList.size(), newInstanceList.size())) {
                return true;
            }
            return this.savedInstanceList.stream().anyMatch(instance -> !newInstanceList.contains(instance));
        }
    }
}

