/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.data.redis.connection.util.ByteArrayWrapper;

public class ByteArraySet
implements Set<ByteArrayWrapper> {
    LinkedHashSet<ByteArrayWrapper> delegate = new LinkedHashSet();

    public ByteArraySet() {
    }

    public ByteArraySet(Collection<byte[]> values) {
        this();
        this.addAll((Iterable<byte[]>)values);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof byte[]) {
            return this.delegate.contains(new ByteArrayWrapper((byte[])o));
        }
        return this.delegate.contains(o);
    }

    @Override
    public boolean add(ByteArrayWrapper e) {
        return this.delegate.add(e);
    }

    @Override
    public boolean add(byte[] e) {
        return this.delegate.add(new ByteArrayWrapper(e));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof byte[] ? !this.contains(new ByteArrayWrapper((byte[])o)) : !this.contains(o))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends ByteArrayWrapper> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean addAll(Iterable<byte[]> c) {
        for (byte[] o : c) {
            this.add(o);
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<ByteArrayWrapper> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof byte[]) {
            this.delegate.remove(new ByteArrayWrapper((byte[])o));
        }
        return this.delegate.remove(o);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.remove(o);
        }
        return true;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public Set<byte[]> asRawSet() {
        LinkedHashSet<byte[]> result = new LinkedHashSet<byte[]>();
        for (ByteArrayWrapper wrapper : this.delegate) {
            result.add(wrapper.getArray());
        }
        return result;
    }
}

