/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.io.ObjectStreamException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.opengis.annotation.UML;

final class StandardImplementation
extends MetadataStandard {
    private static final long serialVersionUID = 855786625369724248L;
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.metadata");
    private final String implementationPackage;
    private static final String[] IMPL_PREFIXES = new String[]{"Default", "Abstract"};
    private final String[] acronyms;
    private transient Map<Class<?>, Class<?>> implementations;

    StandardImplementation(String citation, String interfacePackage, String implementationPackage, String[] acronyms, MetadataStandard ... dependencies) {
        super(citation, interfacePackage, dependencies);
        this.implementationPackage = implementationPackage;
        this.acronyms = acronyms;
        this.implementations = new IdentityHashMap();
    }

    @Override
    boolean isPendingAPI(Class<?> type) {
        return type.getName().startsWith(this.implementationPackage) && type.isAnnotationPresent(UML.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Class<? extends T> getImplementation(Class<T> type) {
        String classname;
        if (type != null && type.isInterface() && this.isSupported(classname = type.getName())) {
            Map<Class<?>, Class<?>> map = this.implementations;
            synchronized (map) {
                Class<?> candidate = this.implementations.get(type);
                if (candidate != null) {
                    return candidate != Void.TYPE ? candidate.asSubclass(type) : null;
                }
                StringBuilder buffer = new StringBuilder(this.implementationPackage).append(classname, this.interfacePackage.length(), classname.length());
                if (this.acronyms != null) {
                    for (int i = 0; i < this.acronyms.length; i += 2) {
                        String acronym = this.acronyms[i];
                        if (!CharSequences.endsWith((CharSequence)buffer, (CharSequence)acronym, (boolean)false)) continue;
                        buffer.setLength(buffer.length() - acronym.length());
                        buffer.append(this.acronyms[i + 1]);
                        break;
                    }
                }
                int prefixPosition = buffer.lastIndexOf(".") + 1;
                int length = 0;
                for (String p : IMPL_PREFIXES) {
                    classname = buffer.replace(prefixPosition, prefixPosition + length, p).toString();
                    try {
                        candidate = Class.forName(classname);
                    }
                    catch (ClassNotFoundException e) {
                        Logging.recoverableException((Logger)LOGGER, MetadataStandard.class, (String)"getImplementation", (Throwable)e);
                        length = p.length();
                        continue;
                    }
                    this.implementations.put(type, candidate);
                    return candidate.asSubclass(type);
                }
                this.implementations.put(type, Void.TYPE);
            }
        }
        return null;
    }

    Object readResolve() throws ObjectStreamException {
        for (MetadataStandard standard : MetadataStandard.INSTANCES) {
            if (!standard.citation.equals((Object)this.citation)) continue;
            return standard;
        }
        this.implementations = new IdentityHashMap();
        return this;
    }
}

