/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.AuthorityFactoryProxy;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.MissingFactoryResourceException;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Messages;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class IdentifiedObjectSet<T extends IdentifiedObject>
extends AbstractSet<T>
implements CheckedContainer<T>,
Localized {
    final Map<String, T> objects;
    protected final AuthorityFactory factory;
    private final AuthorityFactoryProxy<? super T> proxy;
    private final Class<T> type;

    public IdentifiedObjectSet(AuthorityFactory factory, Class<T> type) {
        this.factory = Objects.requireNonNull(factory);
        this.type = Objects.requireNonNull(type);
        this.proxy = AuthorityFactoryProxy.getInstance(type);
        this.objects = new LinkedHashMap<String, T>();
    }

    public Locale getLocale() {
        return this.factory instanceof Localized ? ((Localized)this.factory).getLocale() : null;
    }

    public Class<T> getElementType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<String, T> map = this.objects;
        synchronized (map) {
            this.objects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<String, T> map = this.objects;
        synchronized (map) {
            return this.objects.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAuthorityCodes() {
        Map<String, T> map = this.objects;
        synchronized (map) {
            return (String[])this.objects.keySet().toArray(String[]::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthorityCodes(String ... codes) {
        Map<String, T> map = this.objects;
        synchronized (map) {
            HashMap<String, T> copy = new HashMap<String, T>(this.objects);
            this.objects.clear();
            for (String code : codes) {
                this.objects.put(code, (IdentifiedObject)copy.get(code));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthorityCode(String code) {
        Map<String, T> map = this.objects;
        synchronized (map) {
            this.objects.putIfAbsent(code, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T object) {
        IdentifiedObject previous;
        String code = this.getAuthorityCode(object);
        Map<String, T> map = this.objects;
        synchronized (map) {
            previous = (IdentifiedObject)this.objects.put(code, object);
        }
        return !Objects.equals(previous, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T get(String code) throws BackingStoreException {
        boolean success;
        Object object;
        Map<String, T> map = this.objects;
        synchronized (map) {
            object = (IdentifiedObject)this.objects.get(code);
            success = object != null || !this.objects.containsKey(code);
        }
        if (!success) {
            try {
                object = this.createObject(code);
                success = true;
            }
            catch (FactoryException exception) {
                if (!this.isRecoverableFailure(exception)) {
                    throw new BackingStoreException((Throwable)exception);
                }
                LogRecord record = Messages.forLocale((Locale)this.getLocale()).createLogRecord(Level.WARNING, (short)3, this.type, (Object)code, (Object)IdentifiedObjectSet.getCause(exception));
                Logging.completeAndLog((Logger)GeodeticAuthorityFactory.LOGGER, IdentifiedObjectSet.class, (String)"createObject", (LogRecord)record);
            }
            map = this.objects;
            synchronized (map) {
                if (success) {
                    IdentifiedObject c;
                    if (this.objects.containsKey(code) && (c = this.objects.putIfAbsent(code, object)) != null) {
                        object = c;
                    }
                } else {
                    this.objects.remove(code, null);
                }
            }
        }
        return (T)object;
    }

    @Override
    public boolean contains(Object object) {
        return object != null && object.equals(this.get(this.getAuthorityCode((IdentifiedObject)this.type.cast(object))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAuthorityCode(String code) {
        Map<String, T> map = this.objects;
        synchronized (map) {
            this.objects.remove(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        String code;
        T current;
        if (object != null && object.equals(current = this.get(code = this.getAuthorityCode((IdentifiedObject)this.type.cast(object))))) {
            Map<String, T> map = this.objects;
            synchronized (map) {
                this.objects.remove(code);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean modified = false;
        for (Object object : collection) {
            modified |= this.remove(object);
        }
        return modified;
    }

    @Override
    public Iterator<T> iterator() throws BackingStoreException {
        return new Iterator<T>(){
            private final String[] keys;
            private int index;
            private T next;
            private boolean canRemove;
            {
                this.keys = IdentifiedObjectSet.this.getAuthorityCodes();
            }

            @Override
            public boolean hasNext() throws BackingStoreException {
                while (this.next == null) {
                    if (this.index >= this.keys.length) {
                        return false;
                    }
                    this.next = IdentifiedObjectSet.this.get(this.keys[this.index++]);
                }
                return true;
            }

            @Override
            public T next() throws NoSuchElementException {
                this.canRemove = this.hasNext();
                if (this.canRemove) {
                    Object e = this.next;
                    this.next = null;
                    return e;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (!this.canRemove) {
                    throw new IllegalStateException();
                }
                IdentifiedObjectSet.this.removeAuthorityCode(this.keys[this.index - 1]);
                this.canRemove = false;
            }
        };
    }

    public void resolve(int n) throws FactoryException {
        if (n > 0) {
            try {
                Iterator<T> it = this.iterator();
                while (it.hasNext() && --n != 0) {
                    it.next();
                }
            }
            catch (BackingStoreException exception) {
                throw (FactoryException)((Object)exception.unwrapOrRethrow(FactoryException.class));
            }
        }
    }

    protected String getAuthorityCode(T object) {
        Citation authority = this.factory.getAuthority();
        Identifier id = IdentifiedObjects.getIdentifier(object, authority);
        return id != null ? id.getCode() : IdentifiedObjects.getIdentifierOrName(object);
    }

    protected T createObject(String code) throws FactoryException {
        return (T)((IdentifiedObject)this.type.cast(this.proxy.createFromAPI(this.factory, code)));
    }

    protected boolean isRecoverableFailure(FactoryException exception) {
        if (exception instanceof NoSuchIdentifierException) {
            return !(exception instanceof NoSuchAuthorityCodeException);
        }
        return exception instanceof MissingFactoryResourceException;
    }

    private static String getCause(Throwable cause) {
        String lineSeparator = System.lineSeparator();
        StringBuilder trace = new StringBuilder(180);
        while (cause != null) {
            trace.append(lineSeparator).append("  \u2022 ").append(Classes.getShortClassName((Object)cause));
            String message = cause.getMessage();
            if (message != null) {
                trace.append(": ").append(message);
            }
            cause = cause.getCause();
        }
        return trace.toString();
    }
}

